
package HTML::WebMake::CGI::EditBlock;

use strict;
use HTML::WebMake::CGI::Edit;

use vars	qw{
  	@ISA $OK_TMPL $ERRORS_TMPL $COULDNT_FIND_TMPL
        $PAGE_TITLE $PAGE_HEADER
};

@ISA = qw(HTML::WebMake::CGI::Edit);

###########################################################################

$PAGE_TITLE = q{ Edit Tagged Block: &lt;__FNAME__&gt; };      
$PAGE_HEADER = q{ Edit Tagged Block };

$OK_TMPL = qq{ <p>

    Your changes have been submitted.  Thanks!  Now return to <a
    href="__REINVOKE__site=1__">the WebMake file</a>.

</p> };
        
$ERRORS_TMPL = qq{ <p>
    
    Some errors were encountered.  Either go back and re-edit to fix them,
    or abandon the changes that could not be committed and return to <a
    href="__REINVOKE__site=1__">the WebMake file</a>.
        
</p> };
        

$COULDNT_FIND_TMPL = qq{ <p>
        
    Failed to find a content block with ID "{id}".  Return to <a
    href="__REINVOKE__site=1__">the WebMake file</a>.
        
</p> };
#"

###########################################################################

sub new {
  my $class = shift;
  $class = ref($class) || $class;
  my $self = $class->SUPER::new (@_);

  $self->{no_filename_needed} = 1;
  $self->{page_title} = $PAGE_TITLE;
  $self->{page_header} = $PAGE_HEADER;
  $self->{filename} = '';

  bless ($self, $class);
  $self;
}

###########################################################################

sub subrun {
  my ($self, $q) = @_;
  my $form;

  if ($q->param ('dump')) {
    $form = $self->write_dump_page ();
  } elsif ($q->param ('Save')) {
    $form = $self->write_save_page ();
  # } elsif ($q->param ('Preview')) {
    # $form = $self->write_preview_page ();
  } else {
    $form = $self->write_edit_page ();
  }

  $form;
}

sub write_edit_page
{
  my $self = shift;
  my $q = $self->{q};

  my $text = $q->param ('filetext');
  my $id = $q->param ('id');
  if (!defined $text) {
    my $errs = $self->load_filetext_by_id ($id);
    if (defined $errs) { return $errs; }
  }

  $self->{task_breadcrumb} = qq{
    <code>\&lt;$self->{filename}\&gt;</code>
  };#"

  return $self->base_edit_form ($q);
}

# ---------------------------------------------------------------------------

sub cgi_hidden_items {
  my ($self, $q) = @_;

  my $id = $q->param ('id');

  my $saveasid = $q->param ('saveasid');
  $saveasid ||= $q->param ('id');

  return $q->hidden(-name=>'editblock',-value=>'1')
    . $q->hidden(-name=>'id',-value=>$id)
    . $q->hidden (-name=>'f', -value=>$q->param ('f'))
    . $q->hidden(-name=>'saveasid',-value=>$saveasid);
}

# ---------------------------------------------------------------------------

sub get_item_text {
  my ($self, $q) = @_;

  my $text = $q->param ('filetext');

  # strip metadata from the text
  return $self->strip_wmmetas ($text);
}

# ---------------------------------------------------------------------------

sub write_save_page
{
  local ($_);
  my $self = shift;
  my $q = $self->{q};
  my $form = '';

  return unless $self->create_wmmetas ();

  my $textfrom = $q->param ('text_from');
  my $filename;

  $_ = undef;
  if ($q->param('upload')) {
    my $infile = $q->upload ("upload_file");
    if (!defined $infile) {
      $self->warn ("Incomplete upload, didn't receive the new text!");
      goto failed;
    }

    $_ = join ('', <$infile>);

  } elsif ($textfrom eq 'Load from URL') {
    my $url = $q->param ('upload_url');
    $self->warn ("TODO: load from url");

  } else {
    $_ = $q->param ('upload_text');
  }

  my $newtext = $self->{wmmetas}.$_;

  my $wmkf = $q->param ('wmkf');
  $q->param ('f', $wmkf);

  my $handler = new HTML::WebMake::CGI::Site($q);
  $handler->set_file_base ($self->{file_base});
  $form = $handler->modify_text_item ($newtext);
  $self->{msgs} .= $handler->{msgs};

  if ($self->{msgs} ne '') { goto failed; }
  return $form.$self->subst_template ($OK_TMPL);

failed:
  return $form.$self->subst_template ($ERRORS_TMPL);
}

###########################################################################

sub load_filetext_by_id {
  my $self = shift;
  my $id = shift;

  my $q = $self->{q};

  return unless $self->read_wmk_file ($self->{wmkfile});
  my $dir = File::Basename::dirname ($self->{wmkfile});

  my $item;
  foreach my $it (@{$self->{items}}) {
    if ($it->{id} eq $id) { $item = $it; last; }
  }
  if (!defined $item) {
    return $self->subst_template ($COULDNT_FIND_TMPL, { id => $id });
  }

  my $name = $q->escape ($item->{name});
  my $nametext = $item->{name}; $nametext =~ s/[\"\']//gs;

  $q->param (-name=>'filetext', -value=>$item->{edituidata});
  $q->param (-name=>'saveasid', -value=>$item->{id});

  $q->param (-name=>'f', -value=>$nametext);
  $self->{filename} = $nametext;
  return;
}

###########################################################################

1;
