
package HTML::WebMake::CGI::FindWmkf;

use strict;
use File::Find;
use locale;
use HTML::WebMake::CGI::CGIBase;

use vars	qw{
  	@ISA @FOUND $SITE_TMPL $SITE_LI_TMPL
        $PAGE_TITLE $PAGE_HEADER

};

@ISA = qw(HTML::WebMake::CGI::CGIBase);

###########################################################################

$PAGE_TITLE = q{ Choose Site };
$PAGE_HEADER = q{ Choose Site };

$SITE_TMPL = q{
  <ul> {items} </ul> <hr />
};

$SITE_LI_TMPL = q{
  <li> Site: <strong>{file}</strong>
  	<a href="__REINVOKE__wmkf={cgipath}&site=1__">[Edit]</a>
  </li>
};

###########################################################################

sub new {
  my $class = shift;
  $class = ref($class) || $class;
  my $self = $class->SUPER::new (@_);

  $self->{page_title} = $PAGE_TITLE;
  $self->{page_header} = $PAGE_HEADER;
  $self->{no_wmkf_needed} = 1;
  $self->{no_filename_needed} = 1;

  bless ($self, $class);
  $self;
}

###########################################################################

sub subrun {
  my $self = shift;
  my $q = $self->{q};

  $self->write_find_page ();
}

sub wanted {
  return unless (/\.wmk$/i);
  push (@FOUND, $File::Find::name);
}

sub write_find_page
{
  my $self = shift;
  my $q = $self->{q};
  my $form = '';
  my $filebase = $self->{file_base};

  # argh, File::Find needs this temporary global var
  @FOUND = ();
  find (\&wanted, $filebase);
  my @files = sort @FOUND; @FOUND = ();

  foreach my $file (@files) {
    $file =~ s/^.{0,3}\Q${filebase}\E\/?//gs;

    my $cgipath = HTML::WebMake::CGI::CGIBase::mksafepath ($file);
    my $path = $self->{file_base}."/".$cgipath;
    $cgipath = $self->{q}->escape ($cgipath);

    $form .= $self->subst_template ($SITE_LI_TMPL,
    			{ 'file' => $file, 'cgipath' => $cgipath });
  }

  return $self->subst_template ($SITE_TMPL, { 'items' => $form });
}

###########################################################################

1;
