#!/usr/bin/perl -w

$ENV{'SCRIPT'} = '../../../../../../webmake';
use lib '.'; use lib 't';
use WMTest; webmake_t_init("dotdotlinks");
use Test; BEGIN { plan tests => 19 };

# ---------------------------------------------------------------------------

$file = q{
  <webmake>
  <out file="log/dotdotlinks.html" name="log">log $(a) $(b) $(h)</out>
  <out file="log/e/x.html" name="e">e $(f) $(a) $(g)</out>
  <out file="log/e/f/x.html" name="f">f $(b)</out>
  <out file="log/e/f/g/x.html" name="g">g $(f)</out>
  <out file="log/e/f/g/h/x.html" name="h">h $(c)</out>
  <out file="../x.html" name="d">d $(f)</out>
  <out file="../../x.html" name="c">c $(e)</out>
  <out file="../../../x.html" name="b">b $(a) $(d)</out>
  <out file="../../../../x.html" name="a">a $(log) $(h) $(a)</out>
  </webmake>
};

%patterns = (

q{a a/b/c/d/log/dotdotlinks.html a/b/c/d/log/e/f/g/h/x.html x.html}, 'test_a',

q{b ../x.html b/c/x.html}, 'test_b',

q{c c/d/log/e/x.html}, 'test_c',

q{d d/log/e/f/x.html}, 'test_d',

q{log ../../../../../x.html ../../../../x.html ../log/e/f/g/h/x.html}, 'test_log',

q{e ../../log/e/f/x.html ../../../../../../x.html ../../log/e/f/g/x.html}, 'test_e',

q{f ../../../../../../x.html}, 'test_f',

q{g ../../../../log/e/f/x.html}, 'test_g',

q{h ../../../../../../../x.html}, 'test_h',

);

# ---------------------------------------------------------------------------

(-d "log/a/b/c/d/log/e/f/g/h")
	or system ("mkdir -p log/a/b/c/d/log/e/f/g/h");

chdir ("log/a/b/c/d");
wmfile ($file);
ok (wmrun ("-F -f log/test.wmk", \&patterns_run_cb));
chdir ("../../../../..");

checkfile ("a/b/c/d/log/e/f/g/h/x.html", \&patterns_run_cb);
checkfile ("a/b/c/d/log/e/f/g/x.html", \&patterns_run_cb);
checkfile ("a/b/c/d/log/e/f/x.html", \&patterns_run_cb);
checkfile ("a/b/c/d/log/e/x.html", \&patterns_run_cb);
checkfile ("a/b/c/x.html", \&patterns_run_cb);
checkfile ("a/b/x.html", \&patterns_run_cb);
checkfile ("a/x.html", \&patterns_run_cb);
checkfile ("x.html", \&patterns_run_cb);

ok_all_patterns();

