#!/usr/bin/perl -w

use lib '.'; use lib 't';
use WMTest; webmake_t_init("metaset");
use Test; BEGIN { plan tests => 9 };

# ---------------------------------------------------------------------------

$file = q{
<webmake>
  <metaset id="test">
  	T_i_t_l_e_: type=string default="This is foo."
  	_S_c_o_r_e: type=numeric default="20"
  </metaset>

  <usemetaset id="test">
    <content name=foo format="text/et">
    <wmmeta name="_S_c_o_r_e" value=10 />

    This is the foo document. The title looks like this: $[this._S_c_o_r_e]
    </content>

    <content name=bar format="text/et">
    <wmmeta name="T_i_t_l_e_" value="This is bar." />

    This is the bar document. The title looks like this: $[this.T_i_t_l_e_]
    </content>

    <content name=index format="text/et">

    Title for foo: ''$[foo.T_i_t_l_e_]'' Foo's score: $[foo._S_c_o_r_e]

    Title for bar: ''$[bar.T_i_t_l_e_]'' Bar's score: $[bar._S_c_o_r_e]

    </content>

    <out file=log/metaset.html>${index}${foo}${bar}</out>
  </usemetaset>
</webmake>
};

%patterns = (
  q{Title for foo: "This is foo." Foo's score: 10},	'fooidx',
    
  q{Title for bar: "This is bar." Bar's score: 20},	'baridx',

  q{This is the foo document. The title looks like this: 20},	'foodoc',
  
  q{This is the bar document. The title looks like this: This is foo.},
					'bardoc',

);

# ---------------------------------------------------------------------------

wmfile ($file);
ok (wmrun ("-F -f log/test.wmk", \&patterns_run_cb));
ok_all_patterns();

