#!/usr/bin/perl -w

use lib '.'; use lib 't';
use WMTest; webmake_t_init("rssbox");
use Test; BEGIN { plan tests => 15 };

# ---------------------------------------------------------------------------

$file = q{
  <webmake>

  <use plugin="xsl" />
  <use plugin="rssbox" />

  <template name="rss2html.box.background">#88ff88</template>
  <template name="rss2html.title.background">#48ff48</template>
  <template name="rss2html.item.background">#28ff28</template>

  <template name="news.rss09" format="text/xml"
  	src="http://slashdot.org/slashdot.rdf">
  </template>
  <template name="news.rss091" format="text/xml"
  	src="http://www.salon.com/feed/RDF/salon_use.rdf">
  </template>
  <template name="news.rss10" format="text/xml"
  	src="http://meerkat.oreillynet.com/?p=2281&_fl=rss10">
  </template>

  <out file="log/rssbox.html">
    <html><head ><style> ${rss2html.css_text} </style></head>
    <body>
    <rssbox rss="news.rss09" /> <hr />
    <rssbox rss="news.rss091" /> <hr />
    <rssbox rss="news.rss10" /> <hr />
    </body></html>
  </out>

  </webmake>
};

%patterns = (

q{<th> <a class="rsstitle" href="http://slashdot.org/" target="_new">Slashdot</
a> </th> }, 'rss09_title',

q{<td> <a class="rssitem" href="http://slashdot.org/article.pl?sid=}, 'rss09_item',

q{<th> <a class="rsstitle" href="http://www.salon.com" target="_new">Salon.com<
/a> </th> }, 'rss091_title',

q{<td> <a class="rssitem" href="http://www.salon.com}, 'rss091_item',

q{<th> <a class="rsstitle" href="http://meerkat.oreillynet.com/" target="_new">
Meerkat: An Open Wire Service</a> </th>}, 'rss10_title',

q{<tr> <td> <a class="rssitem" href="http://lists.xml.org}, 'rss10_start',

q{</td> </tr> </table> <hr /> </body> </html>}, 'table_end',

);

%allowed_multi = (
  'rss09_item' => 1,
  'rss091_item' => 1,
  'rss10_start' => 1,
);

# ---------------------------------------------------------------------------

wmfile ($file);
ok (wmrun ("-F -f log/test.wmk", \&patterns_run_cb));
ok_all_patterns();

