#!/usr/bin/perl -w

use lib '.'; use lib 't';
use WMTest; webmake_t_init("xsl");
use Test; BEGIN { plan tests => 3 };

# ---------------------------------------------------------------------------

$file = q{
  <webmake>

  <use plugin="xsl" />

  <!-- taken from Sablotron tests ;) -->
  <content name="foo" format=text/xml>
  <?xml version="1.0"?><xml><a/></xml>
  </content>

  <content name="sheet" format=text/xml>
  <?xml version="1.0"?>
  <xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output omit-xml-declaration="yes"/>
  <xsl:template match="a"> OK </xsl:template>
  </xsl:transform>
  </content>

  <out file="log/xsl.html">
  <xsl xmlname="foo" xslname="sheet" />
  </out>
  </webmake>
};

%patterns = (

q{OK}, 'OK',

);

# ---------------------------------------------------------------------------

wmfile ($file);
ok (wmrun ("-F -f log/test.wmk", \&patterns_run_cb));
ok_all_patterns();

