
package HTML::WebMake::CGI::Dir;

use strict;
use HTML::WebMake::CGI::CGIBase;

use vars	qw{
  	@ISA $DIR_LIST_TMPL $DIR_ITEM_TMPL $FILE_ITEM_TMPL
        $PAGE_TITLE $PAGE_HEADER $CREATE_FILE_BOX_TMPL 
};

@ISA = qw(HTML::WebMake::CGI::CGIBase);

###########################################################################

$PAGE_TITLE = q{ Edit Directory };
$PAGE_HEADER = q{ Edit Directory };

$DIR_LIST_TMPL = q{
    <p>Files in <strong>__DIRECTORY__</strong>:</p>
    <ul>
    __FILE_LIST__
    </ul>
    __CREATE_FILE_BOX__
  };
      
$DIR_ITEM_TMPL = q{
  <li>
  <table width=99%>
  <tr>
  <td width=60%>
  Dir: __FILENAME__
  </td>
  <td width=40%>
  <a href="__REINVOKE__dir={cgipath}__">[Go]</a>
  </td>
  </tr>
  </table>
  </li>
};
      
$FILE_ITEM_TMPL = q{
  <li>
  <table width=99%>
  <tr>
  <td width=60%>
  File: __FILENAME__
  </td>
  <td width=40%>
  __FILE_EDIT_LINK__
  <a href="__REINVOKE__del=1&f={cgipath}__">[Delete]</a>  
  </td>
  </tr>
  </table>
  </li>
};

$CREATE_FILE_BOX_TMPL = q{

  <div class=create_file_box>
  __FORM__
  <p class=note>
  (Both text and image files can be created this way.<br />
  They will be differentiated by their file extension.)
  </p>

  </div>

}; #"

###########################################################################

sub new {
  my $class = shift;
  $class = ref($class) || $class;
  my $self = $class->SUPER::new (@_);

  $self->{no_filename_needed} = 1;
  $self->{page_title} = $PAGE_TITLE;
  $self->{page_header} = $PAGE_HEADER;

  bless ($self, $class);
  $self;
}

###########################################################################

sub subrun {
  my $self = shift;
  my $q = $self->{q};

  my $dir = HTML::WebMake::CGI::CGIBase::mksafepath ($q->param('dir'));
  $self->{dir} = $dir;

  my $dirurl = $dir;
  $self->{task_breadcrumb} = qq{
    <a href="__REINVOKE__dir=${dirurl}__">$dir/</a>
    &raquo;
    *
  };#"

  $self->write_list_page ();
}

sub write_list_page
{
  my $self = shift;
  my $q = $self->{q};

  my $form = '';
  if (!defined ($self->{dir})) { $self->{dir} = '.'; }

  if (!opendir (DIR, $self->{file_base}."/".$self->{dir})) {
    $self->warn ("can't opendir {WMROOT}/$self->{dir}: $!");
  }
  my @files = sort readdir (DIR);
  closedir DIR;

  foreach my $file (@files) {
    my $cgipath = $self->makepath ($self->{dir}, $file);
    my $path = $self->{file_base}."/".$cgipath;
    $cgipath = $self->{q}->escape ($cgipath);

    if ($file eq '.') { next; }
    if ($file eq '..') {
      $file = '<em>Up to higher level directory</em>';
    } elsif ($file =~ /^CVS$|^\.\#/) {
      $file = "<em>".$file."</em>";
    } elsif ($path =~ /${HTML::WebMake::CGI::RWMetaTable::METATABLEFNAME}$/) {
      $file = "<em>".$file."</em>";
    } else {
      $file = "<strong>$file</strong>";
    }

    if (-d $path) {
      $form .= $self->subst_template ($DIR_ITEM_TMPL,
      			{ FILENAME => $file, cgipath => $cgipath });
    } else {
      my $editlink = '';

      if ($path =~ /${HTML::WebMake::CGI::RWMetaTable::METATABLEFNAME}$/) {
	$editlink = qq{
	  (used by WebMake for metadata storage)
	  <a href="__REINVOKE__edit=1\&f=${cgipath}__">[Edit XML As Text]</a>
	};#"

      } elsif ($path =~ /\.wmk$/i) {
	$editlink = qq{
	  <a href="__REINVOKE__site=1\&wmkf=${cgipath}__">[Edit WebMake file]</a>
	};#"

      } else {
	$editlink = qq{
	  <a href="__REINVOKE__edit=1\&f=${cgipath}__">[Edit]</a>
	};#"
      }

      # if (!$self->{cvs}->file_in_cvs ($path)) {
      # provide a way to add it? TODO
      # }

      $form .= $self->subst_template ($FILE_ITEM_TMPL,
      			{ FILENAME => $file, cgipath => $cgipath,
			FILE_EDIT_LINK => $editlink });
    }
  }

  my $create = $q->startform(-method => 'GET')
	    . "Create New File: \&nbsp; "
            . $q->hidden (-name=>'edit', -value=>'1')
            . $q->hidden (-name=>'dirprefix', -value=>$self->{dir})
            . $q->textfield (-name => 'f', -default => '',
			      -size=>60, -class=>'wm_short_textfield')
            . $self->std_cgi_hidden_items ($q)
            ." "
            . $q->submit (-name=>'Create', -value=>'Create')
	    . $q->endform();

  my $box = $self->subst_template ($CREATE_FILE_BOX_TMPL,
			{ FORM => $create });

  $form = $self->subst_template ($DIR_LIST_TMPL,
			{ DIRECTORY => $self->{dir}, FILE_LIST => $form,
		      	CREATE_FILE_BOX => $box });

  $form;
}

###########################################################################

1;
