#

package HTML::WebMake::CGIGlue;

###########################################################################

use strict;
use HTML::WebMake::Main;
use vars	qw{ @ISA };
@ISA = ();

###########################################################################

sub new ($$$$$) {
  my $class = shift;
  $class = ref($class) || $class;
  my ($main) = @_;

  my $self = {
    'main'		=> $main,
  };
  bless ($self, $class);

  $self;
}

sub dbg { HTML::WebMake::Main::dbg (@_); }

# -------------------------------------------------------------------------

sub normal_content_in_wmkf_href {
  my ($self, $contobj) = @_;

  my $editcgi = $self->{main}->get_editcgi(); 
  my $cgidat = $self->{main}->{cgi_data};

  my $item;
  foreach $item (@{$cgidat->{items}}) {
    last if ($item->{name} eq $contobj->{name});
  }
  warn "undef item for $contobj->{name}" unless defined($item);

  return $editcgi.'&editblock=1&id='.$item->{id};
}

# -------------------------------------------------------------------------

sub contents_file_href {
  my ($self, $datasource, $fname) = @_;

  my $editcgi = $self->{main}->get_editcgi();
  $fname =~ /^file:(.*)$/;
  return $editcgi.'&edit=1&f='.$datasource->{src}.'/'.$1;
}

# -------------------------------------------------------------------------

1;
