#!/usr/bin/perl -w

use lib '.'; use lib 't';
use WMTest; webmake_t_init("contentsmetatable");
use Test; BEGIN { plan tests => 7 };

# ---------------------------------------------------------------------------

$file = q{
  <webmake>
  <contents src="data/contentsfind.data" name=".../*.txt"
    metatable="metatable.csv" delimiter="|"
  />

  <out file="log/contentsmetatable.html">
    $[foo.txt.testmeta]
    $[dir1/bar.txt.testmeta]
    $[dir2/dir2a/baz.txt.testmeta]
  </out>
  </webmake>
};

%patterns = (

q{TESTMETA foo}, 'foo',
q{TESTMETA bar}, 'bar',
q{TESTMETA baz}, 'baz',

);

# ---------------------------------------------------------------------------

wmfile ($file);
ok (wmrun ("-F -f log/test.wmk", \&patterns_run_cb));
ok_all_patterns();

