#!/usr/bin/perl -w

use lib '.'; use lib 't';
use WMTest; webmake_t_init("contobj_get_meta");
use Test; BEGIN { plan tests => 21 };

# ---------------------------------------------------------------------------

$file = q{
  <webmake>
  <content name="foo"><wmmeta name=title>FooTitle</wmmeta>
  blah!
  </content>
  <content name="bar"><wmmeta name=title>BarTitle</wmmeta>
  <h1>Not Title</h1> <p>blah!</p>
  </content>
  <content name="baz"><wmmeta name=title value="BazTitle" />
  <h1>Not Title: $[this.title]</h1> <p>blah!</p>
  </content>
  <content name="goo" format="text/et">
  <wmmeta name=title value="GooTitle" />
  
  Not Title
  ---------

  </content>
  <content name="lop" format="text/pod">
  <wmmeta name=title value="LopTitle" />
=head1 NAME

Not Title

=head1 SYNOPSIS

=cut
  </content>

  <!-- see if the implicit-title stuff works sensibly... -->
  <content name="foo3real"><wmmeta name=title>Foo3Title</wmmeta>
  blah!
  </content>
  <content name="foo3"><h1>Not the title</h1>${foo3real}</content>

  <contents src="data/getmeta.data" namesubst="s/\.[a-z]+//"
  	name="*.txt" format="text/et" />
  <contents src="data/getmeta.data" namesubst="s/\.[a-z]+//"
  	name="*.html" format="text/html" />
  <contents src="data/getmeta.data" namesubst="s/\.[a-z]+//"
  	name="*.pod" format="text/pod" />

  <out file="log/contobj_get_meta.html">

  <{perl
  	my $foo = get_content_object ("foo");
  	my $bar = get_content_object ("bar");
  	my $baz = get_content_object ("baz");
  	my $goo = get_content_object ("goo");
  	my $lop = get_content_object ("lop");
  	my $foo2 = get_content_object ("foo2");
  	my $bar2 = get_content_object ("bar2");
  	my $baz2 = get_content_object ("baz2");
  	my $goo2 = get_content_object ("goo2");
  	my $lop2 = get_content_object ("lop2");
  	my $foo3 = get_content_object ("foo3");

	$foo->get_metadata ("title")." ".
	$bar->get_metadata ("title")." ".
	$baz->get_metadata ("title")." ".
	$goo->get_metadata ("title")." ".
	$lop->get_metadata ("title")." ".
	$foo2->get_metadata ("title")." ".
	$bar2->get_metadata ("title")." ".
	$baz2->get_metadata ("title")." ".
	$goo2->get_metadata ("title")." ".
	$lop2->get_metadata ("title");
  }>

  </out>
  </webmake>
};

%patterns = (

q{FooTitle}, 'FooTitle',
q{BarTitle}, 'BarTitle',
q{BazTitle}, 'BazTitle',
q{GooTitle}, 'GooTitle',
q{LopTitle}, 'LopTitle',
q{Foo2Title}, 'Foo2Title',
q{Bar2Title}, 'Bar2Title',
q{Baz2Title}, 'Baz2Title',
q{Goo2Title}, 'Goo2Title',
q{Lop2Title}, 'Lop2Title',

);

# ---------------------------------------------------------------------------

wmfile ($file);
ok (wmrun ("-F -f log/test.wmk", \&patterns_run_cb));
ok_all_patterns();

