#!/usr/bin/perl -w

use lib '.'; use lib 't';
use WMTest; webmake_t_init("freetable");
use Test; BEGIN { plan tests => 5 };

# ---------------------------------------------------------------------------

$file = q{
  <webmake>
  <use plugin=wwwtable_tag />

  <content name="foo"><wwwtable>
(1,1)
	foo
(3,3)
	bar
  </wwwtable></content>

  <out file="log/freetable.html">${foo}</out>
  </webmake>
};

%patterns = (

q{<td> foo </td>}, 'foo',
q{<td> bar </td>}, 'bar',

);

# ---------------------------------------------------------------------------

my $ft = `which freetable`;
if (defined $ft && chop $ft && -x $ft) {
  wmfile ($file);
  ok (wmrun ("-F -f log/test.wmk", \&patterns_run_cb));
  ok_all_patterns();

} else {
  for my $i (1..5) {
    skip (1, 0);
  }
}

