#!/usr/bin/perl -w
#
# A quick Win32 installer that creates .bat files for the Perl scripts.

@EXE_FILES = qw{
  	webmake
};

my $runperl;
my $perl;
my $runperlscript;
for (".", split ';', $ENV{PATH}) {
  $_ = "." if $_ eq "";
  $runperl =	"$_/runperl.bat" , goto doit if -f "$_/runperl.bat";
  $perl =	"$_/perl.exe"	 , goto doit if -f "$_/perl.exe";
}

if (!defined $runperl && !defined $perl) {
  die "'runperl.bat' and 'perl.exe' not found. ".
      "Is the Perl 'bin' directory in your PATH?\n";
}

use File::Copy;

doit:
foreach my $file (@EXE_FILES) {
  if (defined $runperl) {
    copy ($runperl, $file.".bat");
  } else {
    create_bat ($file.".bat");
  }
  print "Created: $file.bat\n";
}

# generate a quick maketest.pl script which runs the tests
{
  my $file = 'maketest';
  open (OUT, ">$file") or die "cannot write to $file\n";
  print OUT q{#!/usr/bin/perl -w
    $ENV{'PERL_DL_NONLAZY'} = 1;
    @tees = <t/*.t>;
    use Test::Harness qw(&runtests);
    runtests @tees;
  };
  if (defined $runperl) {
    copy ($runperl, $file.".bat");
  } else {
    create_bat ($file.".bat");
  }
  print "Created: $file.bat\n";
  close OUT or die "cannot write to $file\n";
}

sub create_bat {
  my $file = shift;
  if (!defined $runperlscript) {
    $runperlscript = join ('', <DATA>);
    $runperlscript =~ s/\r?\n/\r\n/gs;	# ensure DOS endings
  }
  open (OUT, ">$file"); print OUT $runperlscript; close OUT;
}

# taken directly from runperl.bat from the ActivePerl distro:
__DATA__
@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S "%0" %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!perl -w
#line 15
$0 =~ s|\.bat||i;
unless (-f $0) {
    $0 =~ s|.*[/\\]||;
    for (".", split ';', $ENV{PATH}) {
        $_ = "." if $_ eq "";
        $0 = "$_/$0" , goto doit if -f "$_/$0";
    }
    die "`$0' not found.\n";
}
doit: exec "perl", "-x", $0, @ARGV;
die "Failed to exec `$0': $!";
__END__
:endofperl
