#################################################################
#Copyright (C) 2003 Chris Curvey
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#################################################################

import unittest
import HtmlTestCase

class ClientFormTest(HtmlTestCase.HtmlTestCase):
    def setUp(self):
         self.get("http://localhost:8000/formTest.html")
	 forms = self.findForms()
	 assert len(forms) == 1
	 self.form = forms[0]

    def testFormFunctions(self):
        """
	These apply to input/text, input/password, input/hidden, textarea
	and input/file tags.  But don't use input/file tags yet, there's
	still some work that needs to be done.
	"""
        textfield = self.form.find_control(name="textfield")
	textfield.value = "foobar"

	#alternatively...
	self.form.set_value(value="foobar", name="textfield")
	assert self.form.get_value(name="textfield") == "foobar"

    def testCheckbox(self):
        """
	Note that a checkbox is a list control, so it *must* have 
	a list for a value.  We really should have a multi-check
	box example here.
	"""
        checkbox = self.form.find_control(name="checkedCheckBox")
	assert checkbox.possible_items() == ['on']

	checkbox.toggle_single()
	# alternatively
	checkbox.set_single("checkedCheckBox")
	# alternatively
	self.form.set_value(name="checkedCheckBox", value=["on"])

    def testRadio(self):
        radio = self.form.find_control(name="radioField")

	radio.value = ["one"]
	#alternatively
	radio.toggle("one")
	#alternatively
	self.form.set_value(name="radioField", value=["one"])

	#alternatively (ugly syntax! mostly internally used)
	radio.set(0, "one")
	radio.set(1, "two")

    def testSingleSelect(self):
        select = self.form.find_control(name="singleSelect")

	select.value = ["one"]
	#alternatively
	select.toggle("one")

    def testSingleSelectValue(self):
        select = self.form.find_control(name="singleSelectValue")
	
	select.value=["1"]
	#alternatively
	select.toggle("1")

	# this is cool.  we can set the value based on what is displayed
	# to the user.
	select.toggle("one", by_label=1)

    def testMultipleSelect(self):
        select = self.form.find_control(name="multipleSelect")

	# set the values directly
	select.value=["1", "3"]

	# grab another value
	select.toggle("2")

	# do it by label (unselecting this time)
	select.toggle("two", by_label=1)
	#print self.form

         
if __name__ == "__main__":
    unittest.main()
