#################################################################
#Copyright (C) 2003 Chris Curvey
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#################################################################

import unittest
import HtmlTestCase

class InitTest(HtmlTestCase.HtmlTestCase):
    def testInit(self):
	assert self.testId > 0

##################################################################
class ParseTest(HtmlTestCase.HtmlTestCase):
    def setUp(self):
        self.get("http://chriscurvey.com:8080/curveyConsulting/")

    def testGetTag(self):
	documentTag = self.getTags( "html" )
	assert documentTag[0].contains("Curvey Consulting")

    def testGetTagAttrs(self):
	attrs = [ ("class", "pathBar" ) ]
	divTag = self.getTags("div", attrs)
	assert divTag[0].contains("You are here:")

    def testGetTagContent(self):
        anchor = self.getTags("a", content = "Members")
	assert anchor[0].hasAttr( ("href", "http://chriscurvey.com:8080/curveyConsulting/Members" )) 

    def testMultipleAttrs(self):
        attrs = [ ("type" , "text" ) , ("name" , "__ac_name") ]
	input = self.getTags("input", attrs)
	assert len(input) == 1

	# see if we can make it fail
        attrs = [ ( "cellspacing" , "0" ) , ("cellpadding" , "1") ]
	tables = self.getTags("table", attrs)
	assert len(tables) == 0

    def testTagContainment(self):
        assert self.responseContainsTag("div", [ ( 'class' , 'box' ) ])

##############################################################
class TestUserActions(HtmlTestCase.HtmlTestCase):
    def setUp(self):
        self.get("http://chriscurvey.com:8080/curveyConsulting/")

    def testFollowAnchor(self):
        self.followAnchor(content="Members") 
	title = self.getTags("title") 

	assert len(title) == 1
	assert title[0].contains("Curvey Consulting - Members")

    def testFollowNonexistentAnchor(self):
	self.assertRaises(HtmlTestCase.TagNotFoundError, self.followAnchor, content="monkey")

    def testNonspecificAnchor(self):
        self.get("http://localhost:8000/anchorTest.html")
	self.assertRaises(HtmlTestCase.MultipleTagsError, self.followAnchor, content="Boppity")

    def testMultipleSameAnchors(self):
	# XXX need to create this test with some kind of example
        pass

############################################################
class TestFormHandling(HtmlTestCase.HtmlTestCase):
    def setUp(self):
        self.get("http://chriscurvey.com:8080/curveyConsulting/")

    def testFormParsing(self):
        forms = self.findForms()
	assert len(forms) == 2
	form = forms[0]

	form["SearchableText"] = "HtmlTestCase"

        self.submitForm(form.click())
	assert self.responseContainsString("HTML Unit Testing")
        
#############################################################
class TestTagBehavior(HtmlTestCase.HtmlTestCase):
    def setUp(self):
        self.get("http://chriscurvey.com:8080/curveyConsulting/")

    def testGetTag(self):
        tags = self.getTags(type="div", attrs = [ ( "class" , "personalBar") ])
	assert len(tags) == 1

	nextTags = tags[0].getTags(type="span", content="You are not logged in")
	assert len(nextTags) == 1

#############################################################
# note -- you must have the web server in the "webservers"
# directory up and running.   I should just make that a general 
# thing
class TestFormParsing(HtmlTestCase.HtmlTestCase):
    def setUp(self):
        self.get("http://localhost:8000/formTest.html")

    def testFormParsing(self):
        forms = self.findForms()
	assert len(forms) == 1

	form = forms[0]

	###
	assert form["textfield"] == ""

	assert form["textfieldDefault"] == "textfield value"
	assert form["hiddenfield"] == "hiddenfield value"
	assert form["passwordfield"] == "passwordfield value"

	assert form["checkedCheckBox"] == ["on"]
	
	assert form["uncheckedCheckBox"] == []

        assert form["radioField"] == ["two"]

	# These only work with a patched version of ClientForm.
	assert form["singleSelect"] == ["one"]
	assert form["singleSelectValue"] == ["1"]

	assert len(form["singleSelectDefaultValue"]) == 1
	assert form["singleSelectDefaultValue"][0] == "2"

	assert form["multipleSelect"] == []

	assert len(form["multipleSelectOneDefault"]) == 1
	assert form["multipleSelectOneDefault"][0] == "2"

	assert len(form["multipleSelectMultipleDefault"]) == 2
	assert form["multipleSelectMultipleDefault"][0] == "2"
	assert form["multipleSelectMultipleDefault"][1] == "4"

#############################################################
class PostPrePopulatedForm(HtmlTestCase.HtmlTestCase):
    def setUp(self):
        self.get("http://localhost:8000/formTest.html")

    def testResults(self):
	# try one with no entries.  Kind of a bogus test, but it helps
	# to know that we are parsing the form correctly
	forms = self.findForms()
	assert len(forms) == 1

	form = forms[0]
	self.submitForm(form.click())

        assert not self.responseContainsString("textfield is")
        assert self.responseContainsString("textfieldDefault is textfield value")
	assert self.responseContainsString("hiddenfield is hiddenfield value")
	assert self.responseContainsString("passwordfield is passwordfield value")
	assert self.responseContainsString("checkedCheckBox is on")
        assert self.responseContainsString("radioField is two")

	# this next item is not working.  bug filed at sf.net
        assert self.responseContainsString("singleSelect is one")
        assert self.responseContainsString("singleSelectValue is 1")
        assert self.responseContainsString("singleSelectDefaultValue is 2")
        assert self.responseContainsString("multipleSelectOneDefault is 2")

        assert self.responseContainsString("multipleSelectMultipleDefault is 2 4")

    def testOverride(self):
        forms = self.findForms()
	assert len(forms) == 1
	form = forms[0]

	form["textfield"] = "foobar"
	form["singleSelect"] = ["two"]

	form["singleSelectValue"] = ["2"]

	self.submitForm(form.click())

	assert self.responseContainsString("textfield is foobar")
        assert self.responseContainsString("singleSelect is two")
        
#############################################################
if __name__ == "__main__":
    unittest.main()
    #unittest.main(defaultTest = "TestFormParsing")
