#################################################################
#Copyright (C) 2003 Chris Curvey
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#################################################################

import unittest
import HtmlTestCase

class HtmlTestTagTest(unittest.TestCase):
    def setUp(self):
	attrs = [ ("name" , "myform") ,
	          ("action" , "post") ]
        self.tag = HtmlTestCase.HtmlTestTag("form", attrs)
	self.tag.addContent("Please Enter <em>username</em>")
	self.tag.addPlainText("Please Enter username")

    def testBasic(self):
        assert self.tag.type == "form"
	assert self.tag.attrs[1] == ("action", "post")

    def testContent(self):
        assert self.tag.content == "Please Enter <em>username</em>"

    def testEquivContent(self):
        ec = "<form name=\"myform\" action=\"post\">"
        assert self.tag.genEquivContent() == ec

    def testContains(self):
        assert self.tag.contains("Enter")

    def testHasAttr(self):
        attr = ("action", "post")
	assert self.tag.hasAttr(attr)
	self.failIf(self.tag.hasAttr( ("rocky", "bullwinkle") ))

    def testDisplays(self):
        assert self.tag.displays("Please Enter username")
        
if __name__ == "__main__":
    unittest.main()
