#################################################################
#Copyright (C) 2003 Chris Curvey
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#################################################################

import unittest
import HtmlTestCase
from string import *
import urllib2

class HtmlTestParserTest(unittest.TestCase):
    def setUp(self):
        self.htp = HtmlTestCase.HtmlTestParser()
        html = """
               <html foo="bar" rocky="bullwinkle">
                   <head>
	               <title>
	                   This is the title!
	               </title>
	           </head>
               </html>
               """
        self.htp.feed(html)

    def testCount(self):
        assert len(self.htp.allTags) == 3

    def testTagContent(self):
	foundHtml = 0
	foundHead = 0
	foundTitle = 0

        for tag in self.htp.allTags:
	    if tag.type == "html":
	        foundHtml = 1
            if tag.type == "head":
	        foundHead = 1
            if tag.type == "title":
	        foundTitle = 1

        assert foundHtml
        assert foundHead
        assert foundTitle

    def testTitleContents(self):
        for tag in self.htp.allTags:
	     if tag.type == "title":
	         assert tag.contains("This is the title!")

    def testHeadContents(self):
        for tag in self.htp.allTags:
	    if tag.type == "head":
	        assert tag.contains("<title>")

###############################################################
class TestPloneHomepage(unittest.TestCase):
    def setUp(self):
        self.htp = HtmlTestCase.HtmlTestParser()
        html = """
	            <a href="http://chriscurvey.com:8080/curveyConsulting/login_form">
                <img src="http://chriscurvey.com:8080/curveyConsulting/linkOpaque.gif" alt="" title="" height="11" width="6" border="0" />
                
                Log in
            </a> <!-- this is the tag that's being missed -->
            
            
            <a href="http://chriscurvey.com:8080/curveyConsulting/portal_form/join_form">
                <img src="http://chriscurvey.com:8080/curveyConsulting/linkOpaque.gif" alt="" title="" height="11" width="6" border="0" />
                
                Join
            </a>
        """
	self.htp.feed(html)

    def testPloneHomepage(self):
        assert len(self.htp.allTags) == 4
	foo = self.htp.allTags[0].content.find("join_form")
	assert foo == -1

##################################################################
class ParseTest(unittest.TestCase):
    def setUp(self):
        self.htp = HtmlTestCase.HtmlTestParser()
	resp = urllib2.urlopen("http://chriscurvey.com:8080/curveyConsulting/")
	self.htp.feed(resp.read())

    def testGetTag(self):
	documentTag = self.htp.getTags( "html" )
	assert documentTag[0].contains("Curvey Consulting")

    def testGetTagAttrs(self):
	attrs = [ ("class", "pathBar" ) ]
	divTag = self.htp.getTags ("div", attrs)
	assert divTag[0].contains("You are here:")

    def testGetTagContent(self):
        anchor = self.htp.getTags("a", content = "Members")

	assert len(anchor) == 1

	assert anchor[0].hasAttr( ("href", "http://chriscurvey.com:8080/curveyConsulting/Members" )) 

    def testMultipleAttrs(self):
        attrs = [ ("type" , "text" ) , ("name" , "__ac_name") ]
	input = self.htp.getTags("input", attrs)
	assert len(input) == 1

	# see if we can make it fail
        attrs = [ ( "cellspacing" , "0" ) , ("cellpadding" , "1") ]
	tables = self.htp.getTags("table", attrs)
	assert len(tables) == 0

    def testTagContainment(self):
        assert self.htp.responseContainsTag("div", [ ( 'class' , 'box' ) ])

#####################################################################
class TagContentParseTest(unittest.TestCase):
    def setUp(self):
        self.htp = HtmlTestCase.HtmlTestParser()
	resp = urllib2.urlopen("http://localhost:8000/formTest.html")
	self.htp.feed(resp.read())

    def testFormParse(self):
        selectTags = self.htp.getTags("select", [ ( "name", "singleSelect" ) ] )

	selectParser = HtmlTestCase.HtmlTestParser()
	selectParser.feed(selectTags[0].content)

	assert len(selectParser.allTags) == 3

    def testThreeLevel(self):
        formTags = self.htp.getTags("form")
        formParser = HtmlTestCase.HtmlTestParser()
	formParser.feed(formTags[0].content)

        selectTags = formParser.getTags("select", [("name", "singleSelect")])
	selectParser = HtmlTestCase.HtmlTestParser()
	selectParser.feed(selectTags[0].content)

	assert len(selectParser.allTags) == 3

##################################################################
class SanityTest(unittest.TestCase):
    def setUp(self):
	self.htp = HtmlTestCase.HtmlTestParser()

    def testWellFormed(self):
        html = """
	<html><body></body></html>
	"""
	self.htp.feed(html)
        assert len(self.htp.liveTags) == 0

    def testWellFormedWithImage(self):
        html = """
	<html><body><img><p></body></html>
	"""
	self.htp.feed(html)
	assert len(self.htp.liveTags) == 0

    def testSloppy(self):
        html = """
	<select>
	<option>one
	<option>two
	<option>three
	</select> """ 

	#self.htp.debug=1
	self.htp.feed(html)
	assert len(self.htp.liveTags) == 0

    def testMalformedStrict(self):
         html = """
	 <a href="foo">Foo<a href="bar">
	 """
	 self.htp.strict = 1
	 self.assertRaises(HtmlTestCase.MalformedHtmlError, self.htp.feed, html)

    def testMalformedForgiving(self):
         html = """
	 <body><a href="foo">Foo<a href="bar">Bar</body>
	 """
	 self.htp.strict = 0
	 self.htp.feed(html)

	 assert self.htp.allTags[1].type == "a"
	 assert self.htp.allTags[1].content == "Foo"

    def testMalfomrmedStray(self):
         html = """
	 <html><body></font>
	 """
	 self.htp.feed(html)
	 assert len(self.htp.allTags) == 2

    def testMalformedStrayStrict(self):
         html = """
	 <html><body></font>
	 """
	 self.htp.strict = 1
	 self.assertRaises(HtmlTestCase.MalformedHtmlError, self.htp.feed, html)
         
###################################################################
if __name__ == "__main__":
    unittest.main()
    unittest.main(defaultTest="SanityTest")
