##################################################################
#Copyright (C) 2003 Chris Curvey
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
##################################################################

###################################################################
import unittest
import HttpTestCase

class PythonHomePageTest(HttpTestCase.HttpTestCase):
    def setUp(self):
        self.get("http://localhost:8000/formTest.html")

    def testBasicPage(self):
        self.failUnless(self.responseContainsString("Text Field"))
        self.failIf(self.responseContainsString("Guido"))

    def testHeaders(self):
        self.failUnless(self.responseContainsHeader("Content-Type", "text/html"))
        self.failIf(self.responseContainsHeader("muppet", "bert-is-evil"))
    
##########################################################
class PostTest(HttpTestCase.HttpTestCase):
    def setUp(self):
       #params = { "type_of_search" : "soft",
       #           "words" : "pyunit" }
       #self.post("http://sourceforge.net/search", params)

       params = { "SearchableText" : "HtmlTestCase" }
       self.post("http://chriscurvey.com:8080/curveyConsulting/search", params)
    
    def testSearch(self):
    	self.failUnless(self.status == 200)
    	self.failUnless(self.responseContainsString("HTML Unit Testing"))

####################################################
class CookieTest(HttpTestCase.HttpTestCase):
    def setUp(self):
        params = { "__ac_name" : "Test1",
	           "__ac_password" : "test1" }
        self.post("http://chriscurvey.com:8080/curveyConsulting/logged_in", params)

    def tearDown(self):
        self.get("http://chriscurvey.com:8080/curveyConsulting/logout")

    def testMemberPage(self):
        assert self.responseContainsString("You are now logged in")

    def testFailedPage(self):
	# log out
        self.get("http://chriscurvey.com:8080/curveyConsulting/logout")
	
	# try to get to Test1's folder, even though you're logged out
	self.get("http://chriscurvey.com:8080/curveyConsulting/Members/Test1/folder_contents")
	self.failIf(self.responseContainsString("My Folder"))
	self.failUnless(self.responseContainsString("Please log in"))

####################################################
class ReplaceURLTest(HttpTestCase.HttpTestCase):
    def setUp(self):
        self.setWebServerReplacement("127.0.0.1:8000")

    def testFormPage(self):
        self.get("http://localhost:8000/formTest.html")

	assert self.responseContainsString("Pre-Populated Text Field")
####################################################
if __name__ == "__main__":
    unittest.main()


