/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHLiteral
extends SimpleNode {
    public Object value;

    BSHLiteral(int n2) {
        super(n2);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.value == null) {
            throw new InterpreterError("Null in bsh literal: " + this.value);
        }
        return this.value;
    }

    private char getEscapeChar(char c2) {
        switch (c2) {
            case 'b': {
                c2 = (char)8;
                break;
            }
            case 't': {
                c2 = (char)9;
                break;
            }
            case 'n': {
                c2 = (char)10;
                break;
            }
            case 'f': {
                c2 = (char)12;
                break;
            }
            case 'r': {
                c2 = (char)13;
                break;
            }
        }
        return c2;
    }

    public void charSetup(String string) {
        char c2 = string.charAt(0);
        if (c2 == '\\') {
            c2 = string.charAt(1);
            c2 = Character.isDigit(c2) ? (char)Integer.parseInt(string.substring(1), 8) : this.getEscapeChar(c2);
        }
        this.value = new Primitive(new Character(c2).charValue());
    }

    void stringSetup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '\\') {
                if (Character.isDigit(c2 = string.charAt(++n2))) {
                    int n3 = n2;
                    while (n3 < n2 + 2) {
                        if (!Character.isDigit(string.charAt(n3 + 1))) break;
                        ++n3;
                    }
                    c2 = (char)Integer.parseInt(string.substring(n2, n3 + 1), 8);
                    n2 = n3;
                } else {
                    c2 = this.getEscapeChar(c2);
                }
            }
            stringBuffer.append(c2);
            ++n2;
        }
        this.value = stringBuffer.toString();
    }
}

