/*
 * Decompiled with CFR 0.152.
 */
package bsh.org.objectweb.asm;

import bsh.org.objectweb.asm.ByteVector;
import bsh.org.objectweb.asm.ClassWriter;
import bsh.org.objectweb.asm.CodeVisitor;
import bsh.org.objectweb.asm.Edge;
import bsh.org.objectweb.asm.Item;
import bsh.org.objectweb.asm.Label;

public class CodeWriter
implements CodeVisitor {
    static final boolean CHECK = false;
    CodeWriter next;
    private ClassWriter cw;
    private Item name;
    private Item desc;
    private int access;
    private int maxStack;
    private int maxLocals;
    private ByteVector code = new ByteVector();
    private int catchCount;
    private ByteVector catchTable;
    private int exceptionCount;
    private int[] exceptions;
    private int localVarCount;
    private ByteVector localVar;
    private int lineNumberCount;
    private ByteVector lineNumber;
    private boolean resize;
    private final boolean computeMaxs;
    private int stackSize;
    private int maxStackSize;
    private Label currentBlock;
    private Label blockStack;
    private static final int[] SIZE;
    private Edge head;
    private Edge tail;
    private static Edge pool;

    protected CodeWriter(ClassWriter classWriter, boolean bl2) {
        if (classWriter.firstMethod == null) {
            classWriter.firstMethod = this;
            classWriter.lastMethod = this;
        } else {
            classWriter.lastMethod.next = this;
            classWriter.lastMethod = this;
        }
        this.cw = classWriter;
        this.computeMaxs = bl2;
        if (bl2) {
            this.currentBlock = new Label();
            this.currentBlock.pushed = true;
            this.blockStack = this.currentBlock;
        }
    }

    protected void init(int n2, String string, String string2, String[] stringArray) {
        int n3;
        this.access = n2;
        this.name = this.cw.newUTF8(string);
        this.desc = this.cw.newUTF8(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.exceptionCount = stringArray.length;
            this.exceptions = new int[this.exceptionCount];
            n3 = 0;
            while (n3 < this.exceptionCount) {
                this.exceptions[n3] = this.cw.newClass((String)stringArray[n3]).index;
                ++n3;
            }
        }
        if (this.computeMaxs) {
            n3 = CodeWriter.getArgumentsAndReturnSizes(string2) >> 2;
            if ((n2 & 8) != 0) {
                --n3;
            }
            if (n3 > this.maxLocals) {
                this.maxLocals = n3;
            }
        }
    }

    public void visitInsn(int n2) {
        if (this.computeMaxs) {
            int n3 = this.stackSize + SIZE[n2];
            if (n3 > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
            if ((n2 >= 172 && n2 <= 177 || n2 == 191) && this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.currentBlock = null;
            }
        }
        this.code.put1(n2);
    }

    public void visitIntInsn(int n2, int n3) {
        if (this.computeMaxs && n2 != 188) {
            int n4 = this.stackSize + 1;
            if (n4 > this.maxStackSize) {
                this.maxStackSize = n4;
            }
            this.stackSize = n4;
        }
        if (n2 == 17) {
            this.code.put12(n2, n3);
        } else {
            this.code.put11(n2, n3);
        }
    }

    public void visitVarInsn(int n2, int n3) {
        int n4;
        if (this.computeMaxs) {
            if (n2 == 169) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.currentBlock = null;
                }
            } else {
                n4 = this.stackSize + SIZE[n2];
                if (n4 > this.maxStackSize) {
                    this.maxStackSize = n4;
                }
                this.stackSize = n4;
            }
            if ((n4 = n2 == 22 || n2 == 24 || n2 == 55 || n2 == 57 ? n3 + 2 : n3 + 1) > this.maxLocals) {
                this.maxLocals = n4;
            }
        }
        if (n3 < 4 && n2 != 169) {
            n4 = n2 < 54 ? 26 + (n2 - 21 << 2) + n3 : 59 + (n2 - 54 << 2) + n3;
            this.code.put1(n4);
        } else if (n3 >= 256) {
            this.code.put1(196).put12(n2, n3);
        } else {
            this.code.put11(n2, n3);
        }
    }

    public void visitTypeInsn(int n2, String string) {
        if (this.computeMaxs && n2 == 187) {
            int n3 = this.stackSize + 1;
            if (n3 > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
        }
        this.code.put12(n2, this.cw.newClass((String)string).index);
    }

    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        if (this.computeMaxs) {
            int n3;
            char c2 = string3.charAt(0);
            switch (n2) {
                case 178: {
                    n3 = this.stackSize + (c2 == 'D' || c2 == 'J' ? 2 : 1);
                    break;
                }
                case 179: {
                    n3 = this.stackSize + (c2 == 'D' || c2 == 'J' ? -2 : -1);
                    break;
                }
                case 180: {
                    n3 = this.stackSize + (c2 == 'D' || c2 == 'J' ? 1 : 0);
                    break;
                }
                default: {
                    n3 = this.stackSize + (c2 == 'D' || c2 == 'J' ? -3 : -2);
                }
            }
            if (n3 > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
        }
        this.code.put12(n2, this.cw.newField((String)string, (String)string2, (String)string3).index);
    }

    public void visitMethodInsn(int n2, String string, String string2, String string3) {
        Item item = n2 == 185 ? this.cw.newItfMethod(string, string2, string3) : this.cw.newMethod(string, string2, string3);
        int n3 = item.intVal;
        if (this.computeMaxs) {
            int n4;
            if (n3 == 0) {
                item.intVal = n3 = CodeWriter.getArgumentsAndReturnSizes(string3);
            }
            if ((n4 = n2 == 184 ? this.stackSize - (n3 >> 2) + (n3 & 3) + 1 : this.stackSize - (n3 >> 2) + (n3 & 3)) > this.maxStackSize) {
                this.maxStackSize = n4;
            }
            this.stackSize = n4;
        }
        if (n2 == 185) {
            if (!this.computeMaxs && n3 == 0) {
                item.intVal = n3 = CodeWriter.getArgumentsAndReturnSizes(string3);
            }
            this.code.put12(185, item.index).put11(n3 >> 2, 0);
        } else {
            this.code.put12(n2, item.index);
        }
    }

    public void visitJumpInsn(int n2, Label label) {
        if (this.computeMaxs) {
            if (n2 == 167) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.addSuccessor(this.stackSize, label);
                    this.currentBlock = null;
                }
            } else if (n2 == 168) {
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize + 1, label);
                }
            } else {
                this.stackSize += SIZE[n2];
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize, label);
                }
            }
        }
        if (label.resolved && label.position - this.code.length < Short.MIN_VALUE) {
            if (n2 == 167) {
                this.code.put1(200);
            } else if (n2 == 168) {
                this.code.put1(201);
            } else {
                this.code.put1(n2 <= 166 ? (n2 + 1 ^ 1) - 1 : n2 ^ 1);
                this.code.put2(8);
                this.code.put1(200);
            }
            label.put(this, this.code, this.code.length - 1, true);
        } else {
            this.code.put1(n2);
            label.put(this, this.code, this.code.length - 1, false);
        }
    }

    public void visitLabel(Label label) {
        if (this.computeMaxs) {
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
            }
            this.currentBlock = label;
            this.stackSize = 0;
            this.maxStackSize = 0;
        }
        this.resize |= label.resolve(this, this.code.length, this.code.data);
    }

    public void visitLdcInsn(Object object) {
        int n2;
        Item item = this.cw.newCst(object);
        if (this.computeMaxs) {
            n2 = item.type == 5 || item.type == 6 ? this.stackSize + 2 : this.stackSize + 1;
            if (n2 > this.maxStackSize) {
                this.maxStackSize = n2;
            }
            this.stackSize = n2;
        }
        n2 = item.index;
        if (item.type == 5 || item.type == 6) {
            this.code.put12(20, n2);
        } else if (n2 >= 256) {
            this.code.put12(19, n2);
        } else {
            this.code.put11(18, n2);
        }
    }

    public void visitIincInsn(int n2, int n3) {
        int n4;
        if (this.computeMaxs && (n4 = n2 + 1) > this.maxLocals) {
            this.maxLocals = n4;
        }
        if (n2 > 255 || n3 > 127 || n3 < -128) {
            this.code.put1(196).put12(132, n2).put2(n3);
        } else {
            this.code.put1(132).put11(n2, n3);
        }
    }

    public void visitTableSwitchInsn(int n2, int n3, Label label, Label[] labelArray) {
        int n4;
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
                n4 = 0;
                while (n4 < labelArray.length) {
                    this.addSuccessor(this.stackSize, labelArray[n4]);
                    ++n4;
                }
                this.currentBlock = null;
            }
        }
        n4 = this.code.length;
        this.code.put1(170);
        while (this.code.length % 4 != 0) {
            this.code.put1(0);
        }
        label.put(this, this.code, n4, true);
        this.code.put4(n2).put4(n3);
        int n5 = 0;
        while (n5 < labelArray.length) {
            labelArray[n5].put(this, this.code, n4, true);
            ++n5;
        }
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n2;
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
                n2 = 0;
                while (n2 < labelArray.length) {
                    this.addSuccessor(this.stackSize, labelArray[n2]);
                    ++n2;
                }
                this.currentBlock = null;
            }
        }
        n2 = this.code.length;
        this.code.put1(171);
        while (this.code.length % 4 != 0) {
            this.code.put1(0);
        }
        label.put(this, this.code, n2, true);
        this.code.put4(labelArray.length);
        int n3 = 0;
        while (n3 < labelArray.length) {
            this.code.put4(nArray[n3]);
            labelArray[n3].put(this, this.code, n2, true);
            ++n3;
        }
    }

    public void visitMultiANewArrayInsn(String string, int n2) {
        if (this.computeMaxs) {
            this.stackSize += 1 - n2;
        }
        Item item = this.cw.newClass(string);
        this.code.put12(197, item.index).put1(n2);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        if (this.computeMaxs && !label3.pushed) {
            label3.beginStackSize = 1;
            label3.pushed = true;
            label3.next = this.blockStack;
            this.blockStack = label3;
        }
        ++this.catchCount;
        if (this.catchTable == null) {
            this.catchTable = new ByteVector();
        }
        this.catchTable.put2(label.position);
        this.catchTable.put2(label2.position);
        this.catchTable.put2(label3.position);
        this.catchTable.put2(string != null ? (int)this.cw.newClass((String)string).index : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMaxs(int n2, int n3) {
        if (this.computeMaxs) {
            Object object;
            int n4 = 0;
            Object object2 = this.blockStack;
            while (object2 != null) {
                object = object2;
                object2 = ((Label)object2).next;
                int n5 = ((Label)object).beginStackSize;
                int n6 = n5 + ((Label)object).maxStackSize;
                if (n6 > n4) {
                    n4 = n6;
                }
                Edge edge = ((Label)object).successors;
                while (edge != null) {
                    object = edge.successor;
                    if (!((Label)object).pushed) {
                        ((Label)object).beginStackSize = n5 + edge.stackSize;
                        ((Label)object).pushed = true;
                        ((Label)object).next = object2;
                        object2 = object;
                    }
                    edge = edge.next;
                }
            }
            this.maxStack = n4;
            object = SIZE;
            synchronized (SIZE) {
                if (this.tail != null) {
                    this.tail.poolNext = pool;
                    pool = this.head;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        } else {
            this.maxStack = n2;
            this.maxLocals = n3;
        }
    }

    public void visitLocalVariable(String string, String string2, Label label, Label label2, int n2) {
        if (this.localVar == null) {
            this.cw.newUTF8("LocalVariableTable");
            this.localVar = new ByteVector();
        }
        ++this.localVarCount;
        this.localVar.put2(label.position);
        this.localVar.put2(label2.position - label.position);
        this.localVar.put2(this.cw.newUTF8((String)string).index);
        this.localVar.put2(this.cw.newUTF8((String)string2).index);
        this.localVar.put2(n2);
    }

    public void visitLineNumber(int n2, Label label) {
        if (this.lineNumber == null) {
            this.cw.newUTF8("LineNumberTable");
            this.lineNumber = new ByteVector();
        }
        ++this.lineNumberCount;
        this.lineNumber.put2(label.position);
        this.lineNumber.put2(n2);
    }

    private static int getArgumentsAndReturnSizes(String string) {
        int n2 = 1;
        int n3 = 1;
        while (true) {
            char c2;
            if ((c2 = string.charAt(n3++)) == ')') {
                c2 = string.charAt(n3);
                return n2 << 2 | (c2 == 'V' ? 0 : (c2 == 'D' || c2 == 'J' ? 2 : 1));
            }
            if (c2 == 'L') {
                while (string.charAt(n3++) != ';') {
                }
                ++n2;
                continue;
            }
            if (c2 == '[') {
                while ((c2 = string.charAt(n3)) == '[') {
                    ++n3;
                }
                if (c2 != 'D' && c2 != 'J') continue;
                --n2;
                continue;
            }
            if (c2 == 'D' || c2 == 'J') {
                n2 += 2;
                continue;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSuccessor(int n2, Label label) {
        int[] nArray = SIZE;
        synchronized (SIZE) {
            Edge edge;
            if (pool == null) {
                edge = new Edge();
            } else {
                edge = pool;
                pool = CodeWriter.pool.poolNext;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (this.tail == null) {
                this.tail = edge;
            }
            edge.poolNext = this.head;
            this.head = edge;
            edge.stackSize = n2;
            edge.successor = label;
            edge.next = this.currentBlock.successors;
            this.currentBlock.successors = edge;
            return;
        }
    }

    final int getSize() {
        if (this.resize) {
            this.resizeInstructions(new int[0], new int[0], 0);
        }
        int n2 = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            n2 += 18 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                n2 += 8 + this.localVar.length;
            }
            if (this.lineNumber != null) {
                n2 += 8 + this.lineNumber.length;
            }
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            n2 += 8 + 2 * this.exceptionCount;
        }
        if ((this.access & 0x10000) != 0) {
            this.cw.newUTF8("Synthetic");
            n2 += 6;
        }
        if ((this.access & 0x20000) != 0) {
            this.cw.newUTF8("Deprecated");
            n2 += 6;
        }
        return n2;
    }

    final void put(ByteVector byteVector) {
        int n2;
        byteVector.put2(this.access).put2(this.name.index).put2(this.desc.index);
        int n3 = 0;
        if (this.code.length > 0) {
            ++n3;
        }
        if (this.exceptionCount > 0) {
            ++n3;
        }
        if ((this.access & 0x10000) != 0) {
            ++n3;
        }
        if ((this.access & 0x20000) != 0) {
            ++n3;
        }
        byteVector.put2(n3);
        if (this.code.length > 0) {
            n2 = 12 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                n2 += 8 + this.localVar.length;
            }
            if (this.lineNumber != null) {
                n2 += 8 + this.lineNumber.length;
            }
            byteVector.put2(this.cw.newUTF8((String)"Code").index).put4(n2);
            byteVector.put2(this.maxStack).put2(this.maxLocals);
            byteVector.put4(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            byteVector.put2(this.catchCount);
            if (this.catchCount > 0) {
                byteVector.putByteArray(this.catchTable.data, 0, this.catchTable.length);
            }
            n3 = 0;
            if (this.localVar != null) {
                ++n3;
            }
            if (this.lineNumber != null) {
                ++n3;
            }
            byteVector.put2(n3);
            if (this.localVar != null) {
                byteVector.put2(this.cw.newUTF8((String)"LocalVariableTable").index);
                byteVector.put4(this.localVar.length + 2).put2(this.localVarCount);
                byteVector.putByteArray(this.localVar.data, 0, this.localVar.length);
            }
            if (this.lineNumber != null) {
                byteVector.put2(this.cw.newUTF8((String)"LineNumberTable").index);
                byteVector.put4(this.lineNumber.length + 2).put2(this.lineNumberCount);
                byteVector.putByteArray(this.lineNumber.data, 0, this.lineNumber.length);
            }
        }
        if (this.exceptionCount > 0) {
            byteVector.put2(this.cw.newUTF8((String)"Exceptions").index).put4(2 * this.exceptionCount + 2);
            byteVector.put2(this.exceptionCount);
            n2 = 0;
            while (n2 < this.exceptionCount) {
                byteVector.put2(this.exceptions[n2]);
                ++n2;
            }
        }
        if ((this.access & 0x10000) != 0) {
            byteVector.put2(this.cw.newUTF8((String)"Synthetic").index).put4(0);
        }
        if ((this.access & 0x20000) != 0) {
            byteVector.put2(this.cw.newUTF8((String)"Deprecated").index).put4(0);
        }
    }

    protected int[] resizeInstructions(int[] nArray, int[] nArray2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        byte[] byArray = this.code.data;
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        System.arraycopy(nArray, 0, nArray3, 0, n2);
        System.arraycopy(nArray2, 0, nArray4, 0, n2);
        boolean[] blArray = new boolean[this.code.length];
        int n7 = 3;
        do {
            if (n7 == 3) {
                n7 = 2;
            }
            n6 = 0;
            while (n6 < byArray.length) {
                int n8 = byArray[n6] & 0xFF;
                n5 = 0;
                switch (ClassWriter.TYPE[n8]) {
                    case 0: 
                    case 4: {
                        ++n6;
                        break;
                    }
                    case 8: {
                        if (n8 > 201) {
                            n8 = n8 < 218 ? n8 - 49 : n8 - 20;
                            n4 = n6 + CodeWriter.readUnsignedShort(byArray, n6 + 1);
                        } else {
                            n4 = n6 + CodeWriter.readShort(byArray, n6 + 1);
                        }
                        n3 = CodeWriter.getNewOffset(nArray3, nArray4, n6, n4);
                        if (!(n3 >= Short.MIN_VALUE && n3 <= Short.MAX_VALUE || blArray[n6])) {
                            n5 = n8 == 167 || n8 == 168 ? 2 : 5;
                            blArray[n6] = true;
                        }
                        n6 += 3;
                        break;
                    }
                    case 9: {
                        n6 += 5;
                        break;
                    }
                    case 13: {
                        if (n7 == 1) {
                            n3 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n6);
                            n5 = -(n3 & 3);
                        } else if (!blArray[n6]) {
                            n5 = n6 & 3;
                            blArray[n6] = true;
                        }
                        n6 = n6 + 4 - (n6 & 3);
                        n6 += 4 * (CodeWriter.readInt(byArray, n6 + 8) - CodeWriter.readInt(byArray, n6 + 4) + 1) + 12;
                        break;
                    }
                    case 14: {
                        if (n7 == 1) {
                            n3 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n6);
                            n5 = -(n3 & 3);
                        } else if (!blArray[n6]) {
                            n5 = n6 & 3;
                            blArray[n6] = true;
                        }
                        n6 = n6 + 4 - (n6 & 3);
                        n6 += 8 * CodeWriter.readInt(byArray, n6 + 4) + 8;
                        break;
                    }
                    case 16: {
                        n8 = byArray[n6 + 1] & 0xFF;
                        if (n8 == 132) {
                            n6 += 6;
                            break;
                        }
                        n6 += 4;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 10: {
                        n6 += 2;
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 11: 
                    case 12: {
                        n6 += 3;
                        break;
                    }
                    case 7: {
                        n6 += 5;
                        break;
                    }
                    default: {
                        n6 += 4;
                    }
                }
                if (n5 == 0) continue;
                int[] nArray5 = new int[nArray3.length + 1];
                int[] nArray6 = new int[nArray4.length + 1];
                System.arraycopy(nArray3, 0, nArray5, 0, nArray3.length);
                System.arraycopy(nArray4, 0, nArray6, 0, nArray4.length);
                nArray5[nArray3.length] = n6;
                nArray6[nArray4.length] = n5;
                nArray3 = nArray5;
                nArray4 = nArray6;
                if (n5 <= 0) continue;
                n7 = 3;
            }
            if (n7 >= 3) continue;
            --n7;
        } while (n7 != 0);
        ByteVector byteVector = new ByteVector(this.code.length);
        n6 = 0;
        block24: while (n6 < this.code.length) {
            int n9 = nArray3.length - 1;
            while (n9 >= 0) {
                if (nArray3[n9] == n6 && n9 < n2) {
                    if (nArray2[n9] > 0) {
                        byteVector.putByteArray(null, 0, nArray2[n9]);
                    } else {
                        byteVector.length += nArray2[n9];
                    }
                    nArray[n9] = byteVector.length;
                }
                --n9;
            }
            n5 = byArray[n6] & 0xFF;
            switch (ClassWriter.TYPE[n5]) {
                case 0: 
                case 4: {
                    byteVector.put1(n5);
                    ++n6;
                    break;
                }
                case 8: {
                    if (n5 > 201) {
                        n5 = n5 < 218 ? n5 - 49 : n5 - 20;
                        n4 = n6 + CodeWriter.readUnsignedShort(byArray, n6 + 1);
                    } else {
                        n4 = n6 + CodeWriter.readShort(byArray, n6 + 1);
                    }
                    n3 = CodeWriter.getNewOffset(nArray3, nArray4, n6, n4);
                    if (n3 < Short.MIN_VALUE || n3 > Short.MAX_VALUE) {
                        if (n5 == 167) {
                            byteVector.put1(200);
                        } else if (n5 == 168) {
                            byteVector.put1(201);
                        } else {
                            byteVector.put1(n5 <= 166 ? (n5 + 1 ^ 1) - 1 : n5 ^ 1);
                            byteVector.put2(8);
                            byteVector.put1(200);
                            n3 -= 3;
                        }
                        byteVector.put4(n3);
                    } else {
                        byteVector.put1(n5);
                        byteVector.put2(n3);
                    }
                    n6 += 3;
                    break;
                }
                case 9: {
                    n4 = n6 + CodeWriter.readInt(byArray, n6 + 1);
                    n3 = CodeWriter.getNewOffset(nArray3, nArray4, n6, n4);
                    byteVector.put1(n5);
                    byteVector.put4(n3);
                    n6 += 5;
                    break;
                }
                case 13: {
                    int n10 = n6;
                    n6 = n6 + 4 - (n10 & 3);
                    int n11 = byteVector.length;
                    byteVector.put1(170);
                    while (byteVector.length % 4 != 0) {
                        byteVector.put1(0);
                    }
                    n4 = n10 + CodeWriter.readInt(byArray, n6);
                    n3 = CodeWriter.getNewOffset(nArray3, nArray4, n10, n4);
                    byteVector.put4(n3);
                    int n12 = CodeWriter.readInt(byArray, n6 += 4);
                    byteVector.put4(n12);
                    n12 = CodeWriter.readInt(byArray, n6 += 4) - n12 + 1;
                    byteVector.put4(CodeWriter.readInt(byArray, (n6 += 4) - 4));
                    while (n12 > 0) {
                        n4 = n10 + CodeWriter.readInt(byArray, n6);
                        n6 += 4;
                        n3 = CodeWriter.getNewOffset(nArray3, nArray4, n10, n4);
                        byteVector.put4(n3);
                        --n12;
                    }
                    continue block24;
                }
                case 14: {
                    int n10 = n6;
                    n6 = n6 + 4 - (n10 & 3);
                    int n13 = byteVector.length;
                    byteVector.put1(171);
                    while (byteVector.length % 4 != 0) {
                        byteVector.put1(0);
                    }
                    n4 = n10 + CodeWriter.readInt(byArray, n6);
                    n3 = CodeWriter.getNewOffset(nArray3, nArray4, n10, n4);
                    byteVector.put4(n3);
                    int n12 = CodeWriter.readInt(byArray, n6 += 4);
                    n6 += 4;
                    byteVector.put4(n12);
                    while (n12 > 0) {
                        byteVector.put4(CodeWriter.readInt(byArray, n6));
                        n4 = n10 + CodeWriter.readInt(byArray, n6 += 4);
                        n6 += 4;
                        n3 = CodeWriter.getNewOffset(nArray3, nArray4, n10, n4);
                        byteVector.put4(n3);
                        --n12;
                    }
                    continue block24;
                }
                case 16: {
                    n5 = byArray[n6 + 1] & 0xFF;
                    if (n5 == 132) {
                        byteVector.putByteArray(byArray, n6, 6);
                        n6 += 6;
                        break;
                    }
                    byteVector.putByteArray(byArray, n6, 4);
                    n6 += 4;
                    break;
                }
                case 1: 
                case 3: 
                case 10: {
                    byteVector.putByteArray(byArray, n6, 2);
                    n6 += 2;
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    byteVector.putByteArray(byArray, n6, 3);
                    n6 += 3;
                    break;
                }
                case 7: {
                    byteVector.putByteArray(byArray, n6, 5);
                    n6 += 5;
                    break;
                }
                default: {
                    byteVector.putByteArray(byArray, n6, 4);
                    n6 += 4;
                }
            }
        }
        if (this.catchTable != null) {
            byArray = this.catchTable.data;
            n6 = 0;
            while (n6 < this.catchTable.length) {
                CodeWriter.writeShort(byArray, n6, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n6)));
                CodeWriter.writeShort(byArray, n6 + 2, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n6 + 2)));
                CodeWriter.writeShort(byArray, n6 + 4, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n6 + 4)));
                n6 += 8;
            }
        }
        if (this.localVar != null) {
            byArray = this.localVar.data;
            n6 = 0;
            while (n6 < this.localVar.length) {
                n4 = CodeWriter.readUnsignedShort(byArray, n6);
                n3 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n4);
                CodeWriter.writeShort(byArray, n6, n3);
                n3 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n4 += CodeWriter.readUnsignedShort(byArray, n6 + 2)) - n3;
                CodeWriter.writeShort(byArray, n6, n3);
                n6 += 10;
            }
        }
        if (this.lineNumber != null) {
            byArray = this.lineNumber.data;
            n6 = 0;
            while (n6 < this.lineNumber.length) {
                CodeWriter.writeShort(byArray, n6, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n6)));
                n6 += 4;
            }
        }
        this.code = byteVector;
        return nArray;
    }

    static int readUnsignedShort(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }

    static short readShort(byte[] byArray, int n2) {
        return (short)((byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF);
    }

    static int readInt(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static void writeShort(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 >>> 8);
        byArray[n2 + 1] = (byte)n3;
    }

    static int getNewOffset(int[] nArray, int[] nArray2, int n2, int n3) {
        int n4 = n3 - n2;
        int n5 = 0;
        while (n5 < nArray.length) {
            if (n2 < nArray[n5] && nArray[n5] <= n3) {
                n4 += nArray2[n5];
            } else if (n3 < nArray[n5] && nArray[n5] <= n2) {
                n4 -= nArray2[n5];
            }
            ++n5;
        }
        return n4;
    }

    protected int getCodeSize() {
        return this.code.length;
    }

    protected byte[] getCode() {
        return this.code.data;
    }

    static {
        int[] nArray = new int[202];
        String string = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = string.charAt(n2) - 69;
            ++n2;
        }
        SIZE = nArray;
    }
}

