/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import bsh.BshClassManager;
import bsh.ClassPathException;
import bsh.StringUtil;
import bsh.classpath.BshClassPath;
import bsh.classpath.ClassManagerImpl;
import bsh.classpath.ClassPathListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassBrowser
extends JSplitPane
implements ListSelectionListener,
ClassPathListener {
    BshClassPath classPath;
    BshClassManager classManager;
    JFrame frame;
    JInternalFrame iframe;
    JList classlist;
    JList conslist;
    JList mlist;
    JList fieldlist;
    PackageTree ptree;
    JTextArea methodLine;
    JTree tree;
    String[] packagesList;
    String[] classesList;
    Constructor[] consList;
    Method[] methodList;
    Field[] fieldList;
    String selectedPackage;
    Class selectedClass;
    private static final Color LIGHT_BLUE = new Color(245, 245, 255);

    public ClassBrowser() {
        this(BshClassManager.createClassManager(null));
    }

    public ClassBrowser(BshClassManager bshClassManager) {
        super(0, true);
        this.classManager = bshClassManager;
        this.setBorder(null);
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)splitPaneUI).getDivider().setBorder(null);
        }
    }

    String[] toSortedStrings(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        String[] stringArray = arrayList.toArray(new String[0]);
        return StringUtil.bubbleSort(stringArray);
    }

    void setClist(String string) {
        this.selectedPackage = string;
        HashSet hashSet = this.classPath.getClassesForPackage(string);
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.indexOf("$") != -1) continue;
            arrayList.add(BshClassPath.splitClassname((String)string2)[1]);
        }
        this.classesList = this.toSortedStrings(arrayList);
        this.classlist.setListData(this.classesList);
    }

    String[] parseConstructors(Constructor[] constructorArray) {
        String[] stringArray = new String[constructorArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            Constructor constructor = constructorArray[n2];
            stringArray[n2] = StringUtil.methodString(constructor.getName(), constructor.getParameterTypes());
            ++n2;
        }
        return stringArray;
    }

    String[] parseMethods(Method[] methodArray) {
        String[] stringArray = new String[methodArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = StringUtil.methodString(methodArray[n2].getName(), methodArray[n2].getParameterTypes());
            ++n2;
        }
        return stringArray;
    }

    String[] parseFields(Field[] fieldArray) {
        String[] stringArray = new String[fieldArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            Field field = fieldArray[n2];
            stringArray[n2] = field.getName();
            ++n2;
        }
        return stringArray;
    }

    Constructor[] getPublicConstructors(Constructor[] constructorArray) {
        Vector<Constructor> vector = new Vector<Constructor>();
        int n2 = 0;
        while (n2 < constructorArray.length) {
            if (Modifier.isPublic(constructorArray[n2].getModifiers())) {
                vector.addElement(constructorArray[n2]);
            }
            ++n2;
        }
        Object[] objectArray = new Constructor[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    Method[] getPublicMethods(Method[] methodArray) {
        Vector<Method> vector = new Vector<Method>();
        int n2 = 0;
        while (n2 < methodArray.length) {
            if (Modifier.isPublic(methodArray[n2].getModifiers())) {
                vector.addElement(methodArray[n2]);
            }
            ++n2;
        }
        Object[] objectArray = new Method[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    Field[] getPublicFields(Field[] fieldArray) {
        Vector<Field> vector = new Vector<Field>();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            if (Modifier.isPublic(fieldArray[n2].getModifiers())) {
                vector.addElement(fieldArray[n2]);
            }
            ++n2;
        }
        Object[] objectArray = new Field[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void setConslist(Class clazz) {
        if (clazz == null) {
            this.conslist.setListData(new Object[0]);
            return;
        }
        this.consList = this.getPublicConstructors(clazz.getDeclaredConstructors());
        this.conslist.setListData(this.parseConstructors(this.consList));
    }

    void setMlist(String string) {
        if (string == null) {
            this.mlist.setListData(new Object[0]);
            this.setConslist(null);
            this.setClassTree(null);
            return;
        }
        try {
            this.selectedClass = this.selectedPackage.equals("<unpackaged>") ? this.classManager.classForName(string) : this.classManager.classForName(this.selectedPackage + "." + string);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
        if (this.selectedClass == null) {
            System.err.println("class not found: " + string);
            return;
        }
        this.methodList = this.getPublicMethods(this.selectedClass.getDeclaredMethods());
        this.mlist.setListData(this.parseMethods(this.methodList));
        this.setClassTree(this.selectedClass);
        this.setConslist(this.selectedClass);
        this.setFieldList(this.selectedClass);
    }

    void setFieldList(Class clazz) {
        if (clazz == null) {
            this.fieldlist.setListData(new Object[0]);
            return;
        }
        this.fieldList = this.getPublicFields(clazz.getDeclaredFields());
        this.fieldlist.setListData(this.parseFields(this.fieldList));
    }

    void setMethodLine(Object object) {
        this.methodLine.setText(object == null ? "" : object.toString());
    }

    void setClassTree(Class clazz) {
        if (clazz == null) {
            this.tree.setModel(null);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        do {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(clazz.toString());
            if (defaultMutableTreeNode2 != null) {
                defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            } else {
                defaultMutableTreeNode = defaultMutableTreeNode3;
            }
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        } while ((clazz = clazz.getSuperclass()) != null);
        this.tree.setModel(new DefaultTreeModel(defaultMutableTreeNode2));
        TreeNode treeNode = defaultMutableTreeNode.getParent();
        if (treeNode != null) {
            TreePath treePath = new TreePath(((DefaultTreeModel)this.tree.getModel()).getPathToRoot(treeNode));
            this.tree.expandPath(treePath);
        }
    }

    JPanel labeledPane(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", jComponent);
        jPanel.add("North", new JLabel(string, 0));
        return jPanel;
    }

    public void init() throws ClassPathException {
        this.classPath = ((ClassManagerImpl)this.classManager).getClassPath();
        this.classPath.addListener((ClassPathListener)this);
        Set set = this.classPath.getPackagesSet();
        this.ptree = new PackageTree(set);
        this.ptree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getPath();
                Object[] objectArray = treePath.getPath();
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 1;
                while (n2 < objectArray.length) {
                    stringBuffer.append(objectArray[n2].toString());
                    if (n2 + 1 < objectArray.length) {
                        stringBuffer.append(".");
                    }
                    ++n2;
                }
                ClassBrowser.this.setClist(stringBuffer.toString());
            }
        });
        this.classlist = new JList();
        this.classlist.setBackground(LIGHT_BLUE);
        this.classlist.addListSelectionListener(this);
        this.conslist = new JList();
        this.conslist.addListSelectionListener(this);
        this.mlist = new JList();
        this.mlist.setBackground(LIGHT_BLUE);
        this.mlist.addListSelectionListener(this);
        this.fieldlist = new JList();
        this.fieldlist.addListSelectionListener(this);
        JSplitPane jSplitPane = this.splitPane(0, true, this.labeledPane(new JScrollPane(this.conslist), "Constructors"), this.labeledPane(new JScrollPane(this.mlist), "Methods"));
        JSplitPane jSplitPane2 = this.splitPane(0, true, jSplitPane, this.labeledPane(new JScrollPane(this.fieldlist), "Fields"));
        JSplitPane jSplitPane3 = this.splitPane(1, true, this.labeledPane(new JScrollPane(this.classlist), "Classes"), jSplitPane2);
        jSplitPane3 = this.splitPane(1, true, this.labeledPane(new JScrollPane(this.ptree), "Packages"), jSplitPane3);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.methodLine = new JTextArea(1, 60);
        this.methodLine.setBackground(LIGHT_BLUE);
        this.methodLine.setEditable(false);
        this.methodLine.setLineWrap(true);
        this.methodLine.setWrapStyleWord(true);
        this.methodLine.setFont(new Font("Monospaced", 1, 14));
        this.methodLine.setMargin(new Insets(5, 5, 5, 5));
        this.methodLine.setBorder(new MatteBorder(1, 0, 1, 0, LIGHT_BLUE.darker().darker()));
        jPanel.add("North", this.methodLine);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.tree = new JTree();
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ClassBrowser.this.driveToClass(treeSelectionEvent.getPath().getLastPathComponent().toString());
            }
        });
        this.tree.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setClassTree(null);
        jPanel2.add("Center", this.tree);
        jPanel.add("Center", jPanel2);
        jPanel.setPreferredSize(new Dimension(150, 150));
        this.setTopComponent(jSplitPane3);
        this.setBottomComponent(jPanel);
    }

    private JSplitPane splitPane(int n2, boolean bl2, JComponent jComponent, JComponent jComponent2) {
        JSplitPane jSplitPane = new JSplitPane(n2, bl2, jComponent, jComponent2);
        jSplitPane.setBorder(null);
        SplitPaneUI splitPaneUI = jSplitPane.getUI();
        if (splitPaneUI instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)splitPaneUI).getDivider().setBorder(null);
        }
        return jSplitPane;
    }

    public static void main(String[] stringArray) throws Exception {
        ClassBrowser classBrowser = new ClassBrowser();
        classBrowser.init();
        JFrame jFrame = new JFrame("BeanShell Class Browser v1.0");
        jFrame.getContentPane().add("Center", classBrowser);
        classBrowser.setFrame(jFrame);
        jFrame.pack();
        jFrame.show();
    }

    public void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void setFrame(JInternalFrame jInternalFrame) {
        this.iframe = jInternalFrame;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.classlist) {
            String string;
            String string2 = (String)this.classlist.getSelectedValue();
            this.setMlist(string2);
            if (string2 == null) {
                string = "Package: " + this.selectedPackage;
            } else {
                String string3 = this.selectedPackage.equals("<unpackaged>") ? string2 : this.selectedPackage + "." + string2;
                string = string3 + " (from " + this.classPath.getClassSource(string3) + ")";
            }
            this.setMethodLine(string);
        } else if (listSelectionEvent.getSource() == this.mlist) {
            int n2 = this.mlist.getSelectedIndex();
            if (n2 == -1) {
                this.setMethodLine(null);
            } else {
                this.setMethodLine(this.methodList[n2]);
            }
        } else if (listSelectionEvent.getSource() == this.conslist) {
            int n3 = this.conslist.getSelectedIndex();
            if (n3 == -1) {
                this.setMethodLine(null);
            } else {
                this.setMethodLine(this.consList[n3]);
            }
        } else if (listSelectionEvent.getSource() == this.fieldlist) {
            int n4 = this.fieldlist.getSelectedIndex();
            if (n4 == -1) {
                this.setMethodLine(null);
            } else {
                this.setMethodLine(this.fieldList[n4]);
            }
        }
    }

    public void driveToClass(String string) {
        String[] stringArray = BshClassPath.splitClassname((String)string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (this.classPath.getClassesForPackage(string2).size() == 0) {
            return;
        }
        this.ptree.setSelectedPackage(string2);
        int n2 = 0;
        while (n2 < this.classesList.length) {
            if (this.classesList[n2].equals(string3)) {
                this.classlist.setSelectedIndex(n2);
                this.classlist.ensureIndexIsVisible(n2);
                break;
            }
            ++n2;
        }
    }

    public void toFront() {
        if (this.frame != null) {
            this.frame.toFront();
        } else if (this.iframe != null) {
            this.iframe.toFront();
        }
    }

    public void classPathChanged() {
        Set set = this.classPath.getPackagesSet();
        this.ptree.setPackages(set);
        this.setClist(null);
    }

    class PackageTree
    extends JTree {
        TreeNode root;
        DefaultTreeModel treeModel;
        Map nodeForPackage = new HashMap();

        PackageTree(Collection collection) {
            this.setPackages(collection);
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setExpandsSelectedPaths(true);
        }

        public void setPackages(Collection collection) {
            this.treeModel = this.makeTreeModel(collection);
            this.setModel(this.treeModel);
        }

        DefaultTreeModel makeTreeModel(Collection collection) {
            HashMap hashMap = new HashMap();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String[] stringArray = StringUtil.split(string, ".");
                HashMap hashMap2 = hashMap;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string2 = stringArray[n2];
                    HashMap hashMap3 = (HashMap)hashMap2.get(string2);
                    if (hashMap3 == null) {
                        hashMap3 = new HashMap();
                        hashMap2.put(string2, hashMap3);
                    }
                    hashMap2 = hashMap3;
                    ++n2;
                }
            }
            this.root = this.makeNode(hashMap, "root");
            this.mapNodes(this.root);
            return new DefaultTreeModel(this.root);
        }

        MutableTreeNode makeNode(Map map, String string) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                MutableTreeNode mutableTreeNode;
                String string2 = (String)iterator.next();
                Map map2 = (Map)map.get(string2);
                if (map2.size() == 0) {
                    mutableTreeNode = new DefaultMutableTreeNode(string2);
                    defaultMutableTreeNode.add(mutableTreeNode);
                    continue;
                }
                mutableTreeNode = this.makeNode(map2, string2);
                defaultMutableTreeNode.add(mutableTreeNode);
            }
            return defaultMutableTreeNode;
        }

        void mapNodes(TreeNode treeNode) {
            this.addNodeMap(treeNode);
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                this.mapNodes(treeNode2);
            }
        }

        void addNodeMap(TreeNode treeNode) {
            StringBuffer stringBuffer = new StringBuffer();
            TreeNode treeNode2 = treeNode;
            while (treeNode2 != this.root) {
                stringBuffer.insert(0, treeNode2.toString());
                if (treeNode2.getParent() != this.root) {
                    stringBuffer.insert(0, ".");
                }
                treeNode2 = treeNode2.getParent();
            }
            String string = stringBuffer.toString();
            this.nodeForPackage.put(string, treeNode);
        }

        void setSelectedPackage(String string) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.nodeForPackage.get(string);
            if (defaultMutableTreeNode == null) {
                return;
            }
            TreePath treePath = new TreePath(this.treeModel.getPathToRoot(defaultMutableTreeNode));
            this.setSelectionPath(treePath);
            ClassBrowser.this.setClist(string);
            this.scrollPathToVisible(treePath);
        }
    }
}

