/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JpegSegmentData
implements Serializable {
    private final HashMap _segmentDataMap = new HashMap(10);
    static final long serialVersionUID = 7110175216435025451L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JpegSegmentData FromFile(File file) throws IOException, ClassNotFoundException {
        JpegSegmentData jpegSegmentData;
        block2: {
            ObjectInputStream inputStream = null;
            try {
                inputStream = new ObjectInputStream(new FileInputStream(file));
                jpegSegmentData = (JpegSegmentData)inputStream.readObject();
                Object var4_3 = null;
                if (inputStream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (inputStream == null) break block3;
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return jpegSegmentData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ToFile(File file, JpegSegmentData segmentData) throws IOException {
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(file));
            outputStream.writeObject(segmentData);
            Object var4_3 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (outputStream == null) throw throwable;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    public void addSegment(byte segmentMarker, byte[] segmentBytes) {
        List segmentList = this.getOrCreateSegmentList(segmentMarker);
        segmentList.add(segmentBytes);
    }

    public boolean containsSegment(byte segmentMarker) {
        return this._segmentDataMap.containsKey(new Byte(segmentMarker));
    }

    private List getOrCreateSegmentList(byte segmentMarker) {
        List segmentList;
        Byte key = new Byte(segmentMarker);
        if (this._segmentDataMap.containsKey(key)) {
            segmentList = (List)this._segmentDataMap.get(key);
        } else {
            segmentList = new ArrayList();
            this._segmentDataMap.put(key, segmentList);
        }
        return segmentList;
    }

    public byte[] getSegment(byte segmentMarker, int occurrence) {
        List segmentList = this.getSegmentList(segmentMarker);
        if (segmentList == null || segmentList.size() <= occurrence) {
            return null;
        }
        return (byte[])segmentList.get(occurrence);
    }

    public byte[] getSegment(byte segmentMarker) {
        return this.getSegment(segmentMarker, 0);
    }

    public int getSegmentCount(byte segmentMarker) {
        List segmentList = this.getSegmentList(segmentMarker);
        if (segmentList == null) {
            return 0;
        }
        return segmentList.size();
    }

    private List getSegmentList(byte segmentMarker) {
        return (List)this._segmentDataMap.get(new Byte(segmentMarker));
    }

    public void removeSegment(byte segmentMarker) {
        this._segmentDataMap.remove(new Byte(segmentMarker));
    }

    public void removeSegmentOccurrence(byte segmentMarker, int occurrence) {
        List segmentList = (List)this._segmentDataMap.get(new Byte(segmentMarker));
        segmentList.remove(occurrence);
    }
}

