/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import java.io.Serializable;

public class Rational
extends Number
implements Serializable {
    private final int denominator;
    private int maxSimplificationCalculations = 1000;
    private final int numerator;

    public Rational(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public final byte byteValue() {
        return (byte)this.doubleValue();
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rational)) {
            return false;
        }
        Rational that = (Rational)obj;
        return this.doubleValue() == that.doubleValue();
    }

    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public final int getDenominator() {
        return this.denominator;
    }

    public final int getNumerator() {
        return this.numerator;
    }

    public Rational getReciprocal() {
        return new Rational(this.denominator, this.numerator);
    }

    public Rational getSimplifiedInstance() {
        if (this.tooComplexForSimplification()) {
            return this;
        }
        int factor = 2;
        while (factor <= Math.min(this.denominator, this.numerator)) {
            if (!(factor % 2 == 0 && factor > 2 || factor % 5 == 0 && factor > 5 || this.denominator % factor != 0 || this.numerator % factor != 0)) {
                return new Rational(this.numerator / factor, this.denominator / factor);
            }
            ++factor;
        }
        return this;
    }

    public final int intValue() {
        return (int)this.doubleValue();
    }

    public boolean isInteger() {
        return this.denominator == 1 || this.denominator != 0 && this.numerator % this.denominator == 0 || this.denominator == 0 && this.numerator == 0;
    }

    public final long longValue() {
        return (long)this.doubleValue();
    }

    public final short shortValue() {
        return (short)this.doubleValue();
    }

    public String toSimpleString(boolean allowDecimal) {
        String doubleString;
        if (this.denominator == 0 && this.numerator != 0) {
            return this.toString();
        }
        if (this.isInteger()) {
            return Integer.toString(this.intValue());
        }
        if (this.numerator != 1 && this.denominator % this.numerator == 0) {
            int newDenominator = this.denominator / this.numerator;
            return new Rational(1, newDenominator).toSimpleString(allowDecimal);
        }
        Rational simplifiedInstance = this.getSimplifiedInstance();
        if (allowDecimal && (doubleString = Double.toString(simplifiedInstance.doubleValue())).length() < 5) {
            return doubleString;
        }
        return simplifiedInstance.toString();
    }

    public String toString() {
        return this.numerator + "/" + this.denominator;
    }

    private boolean tooComplexForSimplification() {
        double maxPossibleCalculations = (double)(Math.min(this.denominator, this.numerator) - 1) / 5.0 + 2.0;
        return maxPossibleCalculations > (double)this.maxSimplificationCalculations;
    }
}

