/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import java.io.Serializable;

public class Tag
implements Serializable {
    private final Directory _directory;
    private final int _tagType;

    public Tag(int tagType, Directory directory) {
        this._tagType = tagType;
        this._directory = directory;
    }

    public String getDescription() throws MetadataException {
        return this._directory.getDescription(this._tagType);
    }

    public String getDirectoryName() {
        return this._directory.getName();
    }

    public String getTagName() {
        return this._directory.getTagName(this._tagType);
    }

    public int getTagType() {
        return this._tagType;
    }

    public String getTagTypeHex() {
        String hex = Integer.toHexString(this._tagType);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        return "0x" + hex;
    }

    public String toString() {
        String description;
        try {
            description = this.getDescription();
        }
        catch (MetadataException e2) {
            description = this._directory.getString(this.getTagType()) + " (unable to formulate description)";
        }
        return "[" + this._directory.getName() + "] " + this.getTagName() + " - " + description;
    }
}

