/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class GpsDescriptor
extends TagDescriptor {
    public GpsDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 6: {
                return this.getGpsAltitudeDescription();
            }
            case 5: {
                return this.getGpsAltitudeRefDescription();
            }
            case 9: {
                return this.getGpsStatusDescription();
            }
            case 10: {
                return this.getGpsMeasureModeDescription();
            }
            case 12: {
                return this.getGpsSpeedRefDescription();
            }
            case 14: 
            case 16: 
            case 23: {
                return this.getGpsDirectionReferenceDescription(tagType);
            }
            case 15: 
            case 17: 
            case 24: {
                return this.getGpsDirectionDescription(tagType);
            }
            case 25: {
                return this.getGpsDestinationReferenceDescription();
            }
            case 7: {
                return this.getGpsTimeStampDescription();
            }
            case 4: {
                return this.getGpsLongitudeDescription();
            }
            case 2: {
                return this.getGpsLatitudeDescription();
            }
        }
        return this._directory.getString(tagType);
    }

    public String getGpsAltitudeDescription() throws MetadataException {
        if (!this._directory.containsTag(6)) {
            return null;
        }
        String alititude = this._directory.getRational(6).toSimpleString(true);
        return alititude + " metres";
    }

    public String getGpsAltitudeRefDescription() throws MetadataException {
        if (!this._directory.containsTag(5)) {
            return null;
        }
        int alititudeRef = this._directory.getInt(5);
        if (alititudeRef == 0) {
            return "Sea level";
        }
        return "Unknown (" + alititudeRef + ")";
    }

    public String getGpsDestinationReferenceDescription() {
        if (!this._directory.containsTag(25)) {
            return null;
        }
        String destRef = this._directory.getString(25).trim();
        if ("K".equalsIgnoreCase(destRef)) {
            return "kilometers";
        }
        if ("M".equalsIgnoreCase(destRef)) {
            return "miles";
        }
        if ("N".equalsIgnoreCase(destRef)) {
            return "knots";
        }
        return "Unknown (" + destRef + ")";
    }

    public String getGpsDirectionDescription(int tagType) {
        if (!this._directory.containsTag(tagType)) {
            return null;
        }
        String gpsDirection = this._directory.getString(tagType).trim();
        return gpsDirection + " degrees";
    }

    public String getGpsDirectionReferenceDescription(int tagType) {
        if (!this._directory.containsTag(tagType)) {
            return null;
        }
        String gpsDistRef = this._directory.getString(tagType).trim();
        if ("T".equalsIgnoreCase(gpsDistRef)) {
            return "True direction";
        }
        if ("M".equalsIgnoreCase(gpsDistRef)) {
            return "Magnetic direction";
        }
        return "Unknown (" + gpsDistRef + ")";
    }

    public String getGpsLatitudeDescription() throws MetadataException {
        if (!this._directory.containsTag(2)) {
            return null;
        }
        return this.getHoursMinutesSecondsDescription(2);
    }

    public String getGpsLongitudeDescription() throws MetadataException {
        if (!this._directory.containsTag(4)) {
            return null;
        }
        return this.getHoursMinutesSecondsDescription(4);
    }

    public String getGpsMeasureModeDescription() {
        if (!this._directory.containsTag(10)) {
            return null;
        }
        String gpsSpeedMeasureMode = this._directory.getString(10).trim();
        if ("2".equalsIgnoreCase(gpsSpeedMeasureMode)) {
            return "2-dimensional measurement";
        }
        if ("3".equalsIgnoreCase(gpsSpeedMeasureMode)) {
            return "3-dimensional measurement";
        }
        return "Unknown (" + gpsSpeedMeasureMode + ")";
    }

    public String getGpsSpeedRefDescription() {
        if (!this._directory.containsTag(12)) {
            return null;
        }
        String gpsSpeedRef = this._directory.getString(12).trim();
        if ("K".equalsIgnoreCase(gpsSpeedRef)) {
            return "kph";
        }
        if ("M".equalsIgnoreCase(gpsSpeedRef)) {
            return "mph";
        }
        if ("N".equalsIgnoreCase(gpsSpeedRef)) {
            return "knots";
        }
        return "Unknown (" + gpsSpeedRef + ")";
    }

    public String getGpsStatusDescription() {
        if (!this._directory.containsTag(9)) {
            return null;
        }
        String gpsStatus = this._directory.getString(9).trim();
        if ("A".equalsIgnoreCase(gpsStatus)) {
            return "Measurement in progess";
        }
        if ("V".equalsIgnoreCase(gpsStatus)) {
            return "Measurement Interoperability";
        }
        return "Unknown (" + gpsStatus + ")";
    }

    public String getGpsTimeStampDescription() throws MetadataException {
        if (!this._directory.containsTag(7)) {
            return null;
        }
        int[] timeComponents = this._directory.getIntArray(7);
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append(timeComponents[0]);
        sbuffer.append(":");
        sbuffer.append(timeComponents[1]);
        sbuffer.append(":");
        sbuffer.append(timeComponents[2]);
        sbuffer.append(" UTC");
        return sbuffer.toString();
    }

    public String getHoursMinutesSecondsDescription(int tagType) throws MetadataException {
        Rational[] components = this._directory.getRationalArray(tagType);
        int deg = components[0].intValue();
        float min = components[1].floatValue();
        float sec = components[2].floatValue();
        return String.valueOf(deg) + "\"" + String.valueOf((int)min) + "'" + String.valueOf(sec += min % 1.0f * 60.0f);
    }
}

