/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifDescriptor;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import java.text.DecimalFormat;

public class NikonType2MakernoteDescriptor
extends TagDescriptor {
    public NikonType2MakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getAutoFirmwareVersionDescription() throws MetadataException {
        if (!this._directory.containsTag(1)) {
            return null;
        }
        int[] ints = this._directory.getIntArray(1);
        return ExifDescriptor.convertBytesToVersionString(ints);
    }

    public String getAutoFlashCompensationDescription() throws MetadataException {
        Rational ev = this.getMakernoteDirectory().getAutoFlashCompensation();
        if (ev == null) {
            return "Unknown";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        return decimalFormat.format(ev.floatValue()) + " EV";
    }

    public String getAutoFocusPositionDescription() throws MetadataException {
        if (!this._directory.containsTag(136)) {
            return null;
        }
        int[] values = this._directory.getIntArray(136);
        if (values.length != 4 || values[0] != 0 || values[2] != 0 || values[3] != 0) {
            return "Unknown (" + this._directory.getString(136) + ")";
        }
        switch (values[1]) {
            case 0: {
                return "Centre";
            }
            case 1: {
                return "Top";
            }
            case 2: {
                return "Bottom";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
        }
        return "Unknown (" + values[1] + ")";
    }

    public String getColorModeDescription() {
        if (!this._directory.containsTag(141)) {
            return null;
        }
        String raw = this._directory.getString(141);
        if (raw.startsWith("MODE1")) {
            return "Mode I (sRGB)";
        }
        return raw;
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 132: {
                return this.getLensDescription();
            }
            case 146: {
                return this.getHueAdjustmentDescription();
            }
            case 141: {
                return this.getColorModeDescription();
            }
            case 18: {
                return this.getAutoFlashCompensationDescription();
            }
            case 2: {
                return this.getIsoSettingDescription();
            }
            case 134: {
                return this.getDigitalZoomDescription();
            }
            case 136: {
                return this.getAutoFocusPositionDescription();
            }
            case 1: {
                return this.getAutoFirmwareVersionDescription();
            }
        }
        return this._directory.getString(tagType);
    }

    public String getDigitalZoomDescription() throws MetadataException {
        if (!this._directory.containsTag(134)) {
            return null;
        }
        Rational rational = this._directory.getRational(134);
        if (rational.intValue() == 1) {
            return "No digital zoom";
        }
        return rational.toSimpleString(true) + "x digital zoom";
    }

    public String getHueAdjustmentDescription() {
        if (!this._directory.containsTag(146)) {
            return null;
        }
        return this._directory.getString(146) + " degrees";
    }

    public String getIsoSettingDescription() throws MetadataException {
        if (!this._directory.containsTag(2)) {
            return null;
        }
        int[] values = this._directory.getIntArray(2);
        if (values[0] != 0 || values[1] == 0) {
            return "Unknown (" + this._directory.getString(2) + ")";
        }
        return "ISO " + values[1];
    }

    public String getLensDescription() throws MetadataException {
        if (!this._directory.containsTag(132)) {
            return null;
        }
        Rational[] lensValues = this._directory.getRationalArray(132);
        if (lensValues.length != 4) {
            return this._directory.getString(132);
        }
        StringBuffer description = new StringBuffer();
        description.append(lensValues[0].intValue());
        description.append('-');
        description.append(lensValues[1].intValue());
        description.append("mm f/");
        description.append(lensValues[2].floatValue());
        description.append('-');
        description.append(lensValues[3].floatValue());
        return description.toString();
    }

    private NikonType2MakernoteDirectory getMakernoteDirectory() {
        return (NikonType2MakernoteDirectory)this._directory;
    }
}

