/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class PanasonicMakernoteDescriptor
extends TagDescriptor {
    public PanasonicMakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 28: {
                return this.getMacroModeDescription();
            }
            case 31: {
                return this.getRecordModeDescription();
            }
            case 3584: {
                return this.getPrintImageMatchingInfoDescription();
            }
        }
        return this._directory.getString(tagType);
    }

    public String getMacroModeDescription() throws MetadataException {
        if (!this._directory.containsTag(28)) {
            return null;
        }
        int value = this._directory.getInt(28);
        switch (value) {
            case 1: {
                return "On";
            }
            case 2: {
                return "Off";
            }
        }
        return "Unknown (" + value + ")";
    }

    public String getPrintImageMatchingInfoDescription() throws MetadataException {
        if (!this._directory.containsTag(3584)) {
            return null;
        }
        byte[] bytes = this._directory.getByteArray(3584);
        return "(" + bytes.length + " bytes)";
    }

    public String getRecordModeDescription() throws MetadataException {
        if (!this._directory.containsTag(31)) {
            return null;
        }
        int value = this._directory.getInt(31);
        switch (value) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Portrait";
            }
            case 9: {
                return "Macro";
            }
        }
        return "Unknown (" + value + ")";
    }
}

