/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.MetadataReader;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;

public class IptcReader
implements MetadataReader {
    private final byte[] _data;
    static /* synthetic */ Class class$com$drew$metadata$iptc$IptcDirectory;

    public IptcReader(byte[] data) {
        this._data = data;
    }

    public IptcReader(InputStream is) throws JpegProcessingException {
        this(new JpegSegmentReader(is).readSegment((byte)-19));
    }

    public IptcReader(File jpegFile) throws JpegProcessingException {
        this(new JpegSegmentReader(jpegFile).readSegment((byte)-19));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Metadata extract(Metadata metadata) {
        if (this._data == null) {
            return metadata;
        }
        directory = metadata.getDirectory(IptcReader.class$com$drew$metadata$iptc$IptcDirectory == null ? (IptcReader.class$com$drew$metadata$iptc$IptcDirectory = IptcReader.class$("com.drew.metadata.iptc.IptcDirectory")) : IptcReader.class$com$drew$metadata$iptc$IptcDirectory);
        offset = 0;
        try {
            while (offset < this._data.length - 1) {
                block10: {
                    if (this.get32Bits(offset) != 7170) break block10;
                    ** GOTO lbl39
                }
                ++offset;
            }
            if (true) ** GOTO lbl39
        }
        catch (MetadataException e) {
            directory.addError("Couldn't find start of Iptc data (invalid segment)");
            return metadata;
        }
        do {
            if (this._data[offset] != 28) {
                return metadata;
            }
            if (offset + 5 >= this._data.length) {
                return metadata;
            }
            ++offset;
            try {
                directoryType = this._data[offset++];
                tagType = this._data[offset++];
                tagByteCount = this.get32Bits(offset);
            }
            catch (MetadataException e) {
                directory.addError("Iptc data segment ended mid-way through tag descriptor");
                return metadata;
            }
            if ((offset += 2) + tagByteCount > this._data.length) {
                directory.addError("data for tag extends beyond end of iptc segment");
                return metadata;
            }
            this.processTag(directory, directoryType, tagType, offset, tagByteCount);
            offset += tagByteCount;
lbl39:
            // 3 sources

        } while (offset < this._data.length);
        return metadata;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    private int get32Bits(int offset) throws MetadataException {
        if (offset >= this._data.length) {
            throw new MetadataException("Attempt to read bytes from outside Iptc data buffer");
        }
        return (this._data[offset] & 0xFF) << 8 | this._data[offset + 1] & 0xFF;
    }

    private void processTag(Directory directory, int directoryType, int tagType, int offset, int tagByteCount) {
        int tagIdentifier = tagType | directoryType << 8;
        switch (tagIdentifier) {
            case 512: {
                short shortValue = (short)(this._data[offset] << 8 | this._data[offset + 1]);
                directory.setInt(tagIdentifier, shortValue);
                return;
            }
            case 522: {
                directory.setInt(tagIdentifier, this._data[offset]);
                return;
            }
            case 542: 
            case 567: {
                if (tagByteCount < 8) break;
                String dateStr = new String(this._data, offset, tagByteCount);
                try {
                    int year = Integer.parseInt(dateStr.substring(0, 4));
                    int month = Integer.parseInt(dateStr.substring(4, 6)) - 1;
                    int day = Integer.parseInt(dateStr.substring(6, 8));
                    Date date = new GregorianCalendar(year, month, day).getTime();
                    directory.setDate(tagIdentifier, date);
                    return;
                }
                catch (NumberFormatException e2) {
                    break;
                }
            }
        }
        String str = tagByteCount < 1 ? "" : new String(this._data, offset, tagByteCount);
        if (directory.containsTag(tagIdentifier)) {
            String[] newStrings;
            String[] oldStrings;
            try {
                oldStrings = directory.getStringArray(tagIdentifier);
            }
            catch (MetadataException e3) {
                oldStrings = null;
            }
            if (oldStrings == null) {
                newStrings = new String[1];
            } else {
                newStrings = new String[oldStrings.length + 1];
                int i2 = 0;
                while (i2 < oldStrings.length) {
                    newStrings[i2] = oldStrings[i2];
                    ++i2;
                }
            }
            newStrings[newStrings.length - 1] = str;
            directory.setStringArray(tagIdentifier, newStrings);
        } else {
            directory.setString(tagIdentifier, str);
        }
    }
}

