/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTypes;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class FTPClient
implements FTPClientInterface {
    public static String cvsId = "@(#)$Id: FTPClient.java,v 1.53 2005/11/15 21:02:32 bruceb Exp $";
    private static final int DEFAULT_MONITOR_INTERVAL = 65535;
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final int MAX_PORT = 65535;
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final String SOCKS_PORT = "socksProxyPort";
    private static final String SOCKS_HOST = "socksProxyHost";
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte LINE_FEED = 10;
    private static final String NO_FILES = "NO FILES";
    private static final String EMPTY_DIR = "EMPTY";
    private static final String NO_DATA_SETS_FOUND = "NO DATA SETS FOUND";
    private static final String TRANSFER_COMPLETE = "TRANSFER COMPLETE";
    private static Logger log = Logger.getLogger(FTPClient.class);
    private SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected FTPControlSocket control = null;
    protected FTPDataSocket data = null;
    private int timeout = 0;
    private InetAddress remoteAddr;
    private String remoteHost;
    private int controlPort = 21;
    private boolean autoPassiveIPSubstitution = false;
    private String controlEncoding = "US-ASCII";
    private boolean strictReturnCodes = true;
    private boolean cancelTransfer = false;
    private boolean resume = false;
    private long resumeMarker = 0L;
    private boolean detectTransferMode = false;
    private long monitorInterval = 65535L;
    private int transferBufferSize = 16384;
    private FTPFileFactory fileFactory = null;
    private Locale listingLocale = Locale.getDefault();
    private FTPProgressMonitor monitor = null;
    protected FTPMessageListener messageListener = null;
    private FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode connectMode = FTPConnectMode.PASV;
    protected FTPReply lastValidReply;

    public static int[] getVersion() {
        return VersionDetails.getVersion();
    }

    public static String getBuildTimestamp() {
        return VersionDetails.getBuildTimestamp();
    }

    public FTPClient(String remoteHost) throws IOException, FTPException {
        this(remoteHost, 21, 0);
    }

    public FTPClient(String remoteHost, int controlPort) throws IOException, FTPException {
        this(remoteHost, controlPort, 0);
    }

    public FTPClient(String remoteHost, int controlPort, int timeout) throws IOException, FTPException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout);
    }

    public FTPClient(String remoteHost, int controlPort, int timeout, String encoding) throws IOException, FTPException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout, encoding);
    }

    public FTPClient(InetAddress remoteAddr) throws IOException, FTPException {
        this(remoteAddr, 21, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this(remoteAddr, controlPort, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, int timeout) throws IOException, FTPException {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (controlPort < 0) {
            controlPort = 21;
        }
        this.initialize(new FTPControlSocket(remoteAddr, controlPort, timeout, DEFAULT_ENCODING, null));
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, int timeout, String encoding) throws IOException, FTPException {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (controlPort < 0) {
            controlPort = 21;
        }
        this.initialize(new FTPControlSocket(remoteAddr, controlPort, timeout, encoding, null));
    }

    public FTPClient() {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        log.debug(VersionDetails.report(this));
    }

    public void connect() throws IOException, FTPException {
        this.checkConnection(false);
        log.debug("Connecting to " + this.remoteAddr + ":" + this.controlPort);
        this.initialize(new FTPControlSocket(this.remoteAddr, this.controlPort, this.timeout, this.controlEncoding, this.messageListener));
    }

    public boolean connected() {
        return this.control != null;
    }

    protected void checkConnection(boolean shouldBeConnected) throws FTPException {
        if (shouldBeConnected && !this.connected()) {
            throw new FTPException("The FTP client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!shouldBeConnected && this.connected()) {
            throw new FTPException("The FTP client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    protected void initialize(FTPControlSocket control) throws IOException {
        this.control = control;
        control.setMessageListener(this.messageListener);
        control.setStrictReturnCodes(this.strictReturnCodes);
        control.setTimeout(this.timeout);
        control.setAutoPassiveIPSubstitution(this.autoPassiveIPSubstitution);
    }

    public void debugResponses(boolean on) {
        if (on) {
            Logger.setLevel(Level.DEBUG);
        } else {
            Logger.setLevel(Level.OFF);
        }
    }

    public void setStrictReturnCodes(boolean strict) {
        this.strictReturnCodes = strict;
        if (this.control != null) {
            this.control.setStrictReturnCodes(strict);
        }
    }

    public boolean isStrictReturnCodes() {
        return this.strictReturnCodes;
    }

    public void setDetectTransferMode(boolean detectTransferMode) {
        this.detectTransferMode = detectTransferMode;
    }

    public boolean getDetectTransferMode() {
        return this.detectTransferMode;
    }

    private void chooseTransferMode(String filename) {
        if (this.detectTransferMode) {
            if (FileTypes.ASCII.matches(filename) && this.transferType.equals(FTPTransferType.BINARY)) {
                this.transferType = FTPTransferType.ASCII;
                log.debug("Autodetect on - changed transfer type to ASCII");
            } else if (FileTypes.BINARY.matches(filename) && this.transferType.equals(FTPTransferType.ASCII)) {
                this.transferType = FTPTransferType.BINARY;
                log.debug("Autodetect on - changed transfer type to binary");
            }
        }
    }

    public void setTimeout(int millis) throws IOException {
        this.timeout = millis;
        if (this.control != null) {
            this.control.setTimeout(millis);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRemotePort() {
        return this.controlPort;
    }

    public void setRemotePort(int remotePort) throws FTPException {
        this.checkConnection(false);
        this.controlPort = remotePort;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(int controlPort) throws FTPException {
        this.checkConnection(false);
        this.controlPort = controlPort;
    }

    public InetAddress getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(InetAddress remoteAddr) throws FTPException {
        this.checkConnection(false);
        this.remoteAddr = remoteAddr;
        this.remoteHost = remoteAddr.getHostName();
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) throws IOException, FTPException {
        this.checkConnection(false);
        this.remoteHost = remoteHost;
        this.remoteAddr = InetAddress.getByName(remoteHost);
    }

    public boolean isAutoPassiveIPSubstitution() {
        return this.autoPassiveIPSubstitution;
    }

    public void setAutoPassiveIPSubstitution(boolean autoPassiveIPSubstitution) {
        this.autoPassiveIPSubstitution = autoPassiveIPSubstitution;
        if (this.control != null) {
            this.control.setAutoPassiveIPSubstitution(autoPassiveIPSubstitution);
        }
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String controlEncoding) throws FTPException {
        this.checkConnection(false);
        this.controlEncoding = controlEncoding;
    }

    public FTPMessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(FTPMessageListener listener) {
        this.messageListener = listener;
        if (this.control != null) {
            this.control.setMessageListener(listener);
        }
    }

    public void setConnectMode(FTPConnectMode mode) {
        this.connectMode = mode;
    }

    public FTPConnectMode getConnectMode() {
        return this.connectMode;
    }

    public void setProgressMonitor(FTPProgressMonitor monitor, long interval) {
        this.monitor = monitor;
        this.monitorInterval = interval;
    }

    public void setProgressMonitor(FTPProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setTransferBufferSize(int size) {
        this.transferBufferSize = size;
    }

    public int getTransferBufferSize() {
        return this.transferBufferSize;
    }

    public void cancelTransfer() {
        this.cancelTransfer = true;
        log.warn("cancelTransfer() called");
    }

    public void setPORTIP(String IPAddress) throws FTPException {
        this.setActiveIPAddress(IPAddress);
    }

    public void setActiveIPAddress(String IPAddress) throws FTPException {
        this.checkConnection(true);
        byte[] PORT_IP = new byte[4];
        int len = IPAddress.length();
        int partCount = 0;
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < len && partCount <= 4; ++i2) {
            char ch2 = IPAddress.charAt(i2);
            if (Character.isDigit(ch2)) {
                buf.append(ch2);
            } else if (ch2 != '.') {
                throw new FTPException("Incorrectly formatted IP address: " + IPAddress);
            }
            if (ch2 != '.' && i2 + 1 != len) continue;
            try {
                PORT_IP[partCount++] = (byte)Integer.parseInt(buf.toString());
                buf.setLength(0);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new FTPException("Incorrectly formatted IP address: " + IPAddress);
            }
        }
        this.control.setActivePortIPAddress(PORT_IP);
    }

    public void setActivePortRange(int lowest, int highest) throws FTPException {
        this.checkConnection(true);
        if (lowest < 0 || lowest > highest || highest > 65535) {
            throw new FTPException("Invalid port range specified");
        }
        this.control.setActivePortRange(lowest, highest);
    }

    public void login(String user, String password) throws IOException, FTPException {
        this.checkConnection(true);
        this.user(user);
        if (this.lastValidReply.getReplyCode().equals("230")) {
            return;
        }
        this.password(password);
    }

    public void login(String user, String password, String accountInfo) throws IOException, FTPException {
        this.checkConnection(true);
        this.user(user);
        if (this.lastValidReply.getReplyCode().equals("230")) {
            return;
        }
        this.password(password);
        if (this.lastValidReply.getReplyCode().equals("332")) {
            this.account(accountInfo);
        }
    }

    public void user(String user) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("USER " + user);
        String[] validCodes = new String[]{"230", "331"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void password(String password) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("PASS " + password);
        String[] validCodes = new String[]{"230", "202", "332"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void account(String accountInfo) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("ACCT " + accountInfo);
        String[] validCodes = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public static void initSOCKS(String port, String host) {
        Properties props = System.getProperties();
        props.put(SOCKS_PORT, port);
        props.put(SOCKS_HOST, host);
        System.setProperties(props);
    }

    public static void initSOCKSAuthentication(String username, String password) {
        Properties props = System.getProperties();
        props.put("java.net.socks.username", username);
        props.put("java.net.socks.password", password);
        System.setProperties(props);
    }

    public static void clearSOCKS() {
        Properties prop = System.getProperties();
        prop.remove(SOCKS_HOST);
        prop.remove(SOCKS_PORT);
        System.setProperties(prop);
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public String quote(String command, String[] validCodes) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand(command);
        this.lastValidReply = validCodes != null ? this.control.validateReply(reply, validCodes) : reply;
        return this.lastValidReply.getReplyText();
    }

    public long size(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("SIZE " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, "213");
        String replyText = this.lastValidReply.getReplyText();
        int spacePos = replyText.indexOf(32);
        if (spacePos >= 0) {
            replyText = replyText.substring(0, spacePos);
        }
        try {
            return Long.parseLong(replyText);
        }
        catch (NumberFormatException ex) {
            throw new FTPException("Failed to parse reply: " + replyText);
        }
    }

    public void resume() throws FTPException {
        if (this.transferType.equals(FTPTransferType.ASCII)) {
            throw new FTPException("Resume only supported for BINARY transfers");
        }
        this.resume = true;
    }

    public void cancelResume() throws IOException, FTPException {
        this.restart(0L);
        this.resume = false;
    }

    public void restart(long size) throws IOException, FTPException {
        FTPReply reply = this.control.sendCommand("REST " + size);
        this.lastValidReply = this.control.validateReply(reply, "350");
    }

    public void put(String localPath, String remoteFile) throws IOException, FTPException {
        this.put(localPath, remoteFile, false);
    }

    public void put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        this.put(srcStream, remoteFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(localPath);
        try {
            this.putData(localPath, remoteFile, append);
            this.validateTransfer();
        }
        finally {
            this.transferType = currentType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(remoteFile);
        try {
            this.putData(srcStream, remoteFile, append);
            this.validateTransfer();
        }
        finally {
            this.transferType = currentType;
        }
    }

    public void validateTransfer() throws IOException, FTPException {
        this.checkConnection(true);
        String[] validCodes = new String[]{"225", "226", "250", "426", "450"};
        FTPReply reply = this.control.readReply();
        String code = reply.getReplyCode();
        if ((code.equals("426") || code.equals("450")) && !this.cancelTransfer) {
            throw new FTPException(reply);
        }
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    private void closeDataSocket() {
        if (this.data != null) {
            try {
                this.data.close();
                this.data = null;
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
    }

    private void closeDataSocket(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
        this.closeDataSocket();
    }

    private void closeDataSocket(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
        this.closeDataSocket();
    }

    private void initPut(String remoteFile, boolean append) throws IOException, FTPException {
        this.checkConnection(true);
        this.cancelTransfer = false;
        boolean close = false;
        this.data = null;
        try {
            this.data = this.control.createDataSocket(this.connectMode);
            this.data.setTimeout(this.timeout);
            if (this.resume) {
                if (this.transferType.equals(FTPTransferType.ASCII)) {
                    throw new FTPException("Resume only supported for BINARY transfers");
                }
                this.resumeMarker = this.size(remoteFile);
                this.restart(this.resumeMarker);
            }
            String cmd = append ? "APPE " : "STOR ";
            FTPReply reply = this.control.sendCommand(cmd + remoteFile);
            String[] validCodes = new String[]{"125", "150", "350"};
            this.lastValidReply = this.control.validateReply(reply, validCodes);
        }
        catch (IOException ex) {
            close = true;
            throw ex;
        }
        catch (FTPException ex) {
            close = true;
            throw ex;
        }
        finally {
            if (close) {
                this.resume = false;
                this.closeDataSocket();
            }
        }
    }

    private void putData(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        FileInputStream srcStream = new FileInputStream(localPath);
        this.putData(srcStream, remoteFile, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putData(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        long size = 0L;
        try {
            in = new BufferedInputStream(srcStream);
            this.initPut(remoteFile, append);
            out = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()), this.transferBufferSize * 2);
            if (this.resume) {
                in.skip(this.resumeMarker);
            }
            byte[] buf = new byte[this.transferBufferSize];
            byte[] prevBuf = null;
            long monitorCount = 0L;
            int count = 0;
            boolean isASCII = this.getType() == FTPTransferType.ASCII;
            int separatorPos = 0;
            while ((count = in.read(buf)) > 0 && !this.cancelTransfer) {
                if (isASCII) {
                    for (int i2 = 0; i2 < count; ++i2) {
                        boolean found = true;
                        int skip = 0;
                        while (separatorPos < LINE_SEPARATOR.length && i2 + separatorPos < count) {
                            if (buf[i2 + separatorPos] != LINE_SEPARATOR[separatorPos]) {
                                found = false;
                                break;
                            }
                            ++skip;
                            ++separatorPos;
                        }
                        if (found) {
                            if (separatorPos == LINE_SEPARATOR.length) {
                                out.write(13);
                                out.write(10);
                                size += 2L;
                                monitorCount += 2L;
                                separatorPos = 0;
                                i2 += skip - 1;
                                prevBuf = null;
                                continue;
                            }
                            prevBuf = new byte[skip];
                            for (int k2 = 0; k2 < skip; ++k2) {
                                prevBuf[k2] = buf[i2 + k2];
                            }
                            continue;
                        }
                        if (prevBuf != null) {
                            out.write(prevBuf);
                            size += (long)prevBuf.length;
                            monitorCount += (long)prevBuf.length;
                            prevBuf = null;
                        }
                        out.write(buf[i2]);
                        ++size;
                        ++monitorCount;
                        separatorPos = 0;
                    }
                } else {
                    out.write(buf, 0, count);
                    size += (long)count;
                    monitorCount += (long)count;
                }
                if (prevBuf != null) {
                    out.write(prevBuf);
                    size += (long)prevBuf.length;
                    monitorCount += (long)prevBuf.length;
                }
                if (this.monitor == null || monitorCount <= this.monitorInterval) continue;
                this.monitor.bytesTransferred(size);
                monitorCount = 0L;
            }
            this.resume = false;
        }
        catch (Throwable throwable) {
            this.resume = false;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                log.warn("Caught exception closing input stream", ex);
            }
            this.closeDataSocket(out);
            if (this.monitor != null) {
                this.monitor.bytesTransferred(size);
            }
            log.debug("Transferred " + size + " bytes to remote host");
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ex) {
            log.warn("Caught exception closing input stream", ex);
        }
        this.closeDataSocket(out);
        if (this.monitor != null) {
            this.monitor.bytesTransferred(size);
        }
        log.debug("Transferred " + size + " bytes to remote host");
    }

    public void put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        this.put(bytes, remoteFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(remoteFile);
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            this.put(input, remoteFile, append);
        }
        finally {
            this.transferType = currentType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(remoteFile);
        try {
            this.getData(localPath, remoteFile);
            this.validateTransfer();
        }
        finally {
            this.transferType = currentType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(remoteFile);
        try {
            this.getData(destStream, remoteFile);
            this.validateTransfer();
        }
        finally {
            this.transferType = currentType;
        }
    }

    private void initGet(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.cancelTransfer = false;
        boolean close = false;
        this.data = null;
        try {
            this.data = this.control.createDataSocket(this.connectMode);
            this.data.setTimeout(this.timeout);
            if (this.resume) {
                if (this.transferType.equals(FTPTransferType.ASCII)) {
                    throw new FTPException("Resume only supported for BINARY transfers");
                }
                this.restart(this.resumeMarker);
            }
            FTPReply reply = this.control.sendCommand("RETR " + remoteFile);
            String[] validCodes1 = new String[]{"125", "150"};
            this.lastValidReply = this.control.validateReply(reply, validCodes1);
        }
        catch (IOException ex) {
            close = true;
            throw ex;
        }
        catch (FTPException ex) {
            close = true;
            throw ex;
        }
        finally {
            if (close) {
                this.resume = false;
                this.closeDataSocket();
            }
        }
    }

    private void getData(String localPath, String remoteFile) throws IOException, FTPException {
        File localFile = new File(localPath);
        if (localFile.exists()) {
            if (!localFile.canWrite()) {
                throw new FTPException(localPath + " is readonly - cannot write");
            }
            if (this.resume) {
                this.resumeMarker = localFile.length();
            }
        }
        this.initGet(remoteFile);
        FileOutputStream out = new FileOutputStream(localPath, this.resume);
        try {
            this.getDataAfterInitGet(out);
        }
        catch (IOException ex) {
            localFile.delete();
            log.debug("Deleting local file '" + localFile.getAbsolutePath() + "'");
            throw ex;
        }
    }

    private void getData(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        this.initGet(remoteFile);
        this.getDataAfterInitGet(destStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getDataAfterInitGet(OutputStream destStream) throws IOException, FTPException {
        block26: {
            IOException storedEx;
            long size;
            BufferedInputStream in;
            BufferedOutputStream out;
            block24: {
                int count;
                out = new BufferedOutputStream(destStream);
                in = null;
                size = 0L;
                storedEx = null;
                in = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
                this.data.setTimeout(this.timeout);
                long monitorCount = 0L;
                byte[] chunk = new byte[this.transferBufferSize];
                boolean isASCII = this.getType() == FTPTransferType.ASCII;
                boolean crFound = false;
                while ((count = this.readChunk(in, chunk, this.transferBufferSize)) >= 0 && !this.cancelTransfer) {
                    if (isASCII) {
                        boolean lfFound = false;
                        for (int i2 = 0; i2 < count; ++i2) {
                            boolean bl2 = lfFound = chunk[i2] == 10;
                            if (crFound) {
                                if (lfFound) {
                                    out.write(LINE_SEPARATOR, 0, LINE_SEPARATOR.length);
                                    size += (long)LINE_SEPARATOR.length;
                                    monitorCount += (long)LINE_SEPARATOR.length;
                                } else {
                                    out.write(13);
                                    ++size;
                                    ++monitorCount;
                                }
                            }
                            boolean bl3 = crFound = chunk[i2] == 13;
                            if (lfFound || crFound) continue;
                            out.write(chunk[i2]);
                            ++size;
                            ++monitorCount;
                        }
                    } else {
                        out.write(chunk, 0, count);
                        size += (long)count;
                        monitorCount += (long)count;
                    }
                    if (this.monitor == null || monitorCount <= this.monitorInterval) continue;
                    this.monitor.bytesTransferred(size);
                    monitorCount = 0L;
                }
                if (!isASCII || !crFound) break block24;
                out.write(13);
                ++size;
                ++monitorCount;
            }
            Object var16_14 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex2) {
                log.warn("Caught exception closing output stream", ex2);
            }
            this.resume = false;
            this.closeDataSocket(in);
            if (storedEx != null) {
                throw storedEx;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(size);
            }
            log.debug("Transferred " + size + " bytes from remote host");
            {
                break block26;
                catch (IOException ex) {
                    storedEx = ex;
                    Object var16_15 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ex2) {
                        log.warn("Caught exception closing output stream", ex2);
                    }
                    this.resume = false;
                    this.closeDataSocket(in);
                    if (storedEx != null) {
                        throw storedEx;
                    }
                    if (this.monitor != null) {
                        this.monitor.bytesTransferred(size);
                    }
                    log.debug("Transferred " + size + " bytes from remote host");
                }
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex2) {
                    log.warn("Caught exception closing output stream", ex2);
                }
                this.resume = false;
                this.closeDataSocket(in);
                if (storedEx != null) {
                    throw storedEx;
                }
                if (this.monitor != null) {
                    this.monitor.bytesTransferred(size);
                }
                log.debug("Transferred " + size + " bytes from remote host");
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(String remoteFile) throws IOException, FTPException {
        FTPTransferType currentType = this.transferType;
        this.chooseTransferMode(remoteFile);
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream(this.transferBufferSize);
            this.getData(result, remoteFile);
            this.validateTransfer();
            byte[] byArray = result == null ? null : result.toByteArray();
            return byArray;
        }
        finally {
            this.transferType = currentType;
        }
    }

    public boolean site(String command) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("SITE " + command);
        String[] validCodes = new String[]{"200", "202", "502"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return reply.getReplyCode().equals("200");
    }

    public String list(String dirname) throws IOException, FTPException {
        return this.list(dirname, false);
    }

    public String list(String dirname, boolean full) throws IOException, FTPException {
        String[] list = this.dir(dirname, full);
        StringBuffer result = new StringBuffer();
        String sep = System.getProperty("line.separator");
        for (int i2 = 0; i2 < list.length; ++i2) {
            result.append(list[i2]);
            result.append(sep);
        }
        return result.toString();
    }

    public void setFTPFileFactory(FTPFileFactory fileFactory) {
        this.fileFactory = fileFactory;
    }

    public void setParserLocale(Locale locale) {
        this.listingLocale = locale;
    }

    public FTPFile[] dirDetails(String dirname) throws IOException, FTPException, ParseException {
        if (this.fileFactory == null) {
            this.fileFactory = new FTPFileFactory(this.system());
        }
        this.fileFactory.setLocale(this.listingLocale);
        return this.fileFactory.parse(this.dir(dirname, true));
    }

    public String[] dir() throws IOException, FTPException {
        return this.dir(null, false);
    }

    public String[] dir(String dirname) throws IOException, FTPException {
        return this.dir(dirname, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        this.checkConnection(true);
        try {
            String command;
            this.data = this.control.createDataSocket(this.connectMode);
            this.data.setTimeout(this.timeout);
            String string = command = full ? "LIST " : "NLST ";
            if (dirname != null) {
                command = command + dirname;
            }
            command = command.trim();
            FTPReply reply = this.control.sendCommand(command);
            String[] validCodes1 = new String[]{"125", "150", "226", "450", "550"};
            this.lastValidReply = this.control.validateReply(reply, validCodes1);
            Object[] result = new String[]{};
            String replyCode = this.lastValidReply.getReplyCode();
            if (!(replyCode.equals("450") || replyCode.equals("550") || replyCode.equals("226"))) {
                BufferedReader in = null;
                Vector<String> lines = new Vector<String>();
                try {
                    in = new LineNumberReader(new InputStreamReader(this.data.getInputStream()));
                    String line = null;
                    while ((line = this.readLine((LineNumberReader)in)) != null) {
                        lines.addElement(line);
                    }
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        log.error("Failed to close socket in dir()", ex);
                    }
                    this.closeDataSocket();
                }
                String[] validCodes2 = new String[]{"226", "250"};
                reply = this.control.readReply();
                this.lastValidReply = this.control.validateReply(reply, validCodes2);
                if (!lines.isEmpty()) {
                    result = new String[lines.size()];
                    lines.copyInto(result);
                }
            } else if (this.lastValidReply.getReplyText().toUpperCase().indexOf(NO_FILES) < 0 && this.lastValidReply.getReplyText().toUpperCase().indexOf(EMPTY_DIR) < 0 && this.lastValidReply.getReplyText().toUpperCase().indexOf(NO_DATA_SETS_FOUND) < 0 && this.lastValidReply.getReplyText().toUpperCase().indexOf(TRANSFER_COMPLETE) < 0) {
                throw new FTPException(reply);
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.closeDataSocket();
        }
    }

    protected int readChunk(BufferedInputStream in, byte[] chunk, int chunksize) throws IOException {
        return in.read(chunk, 0, chunksize);
    }

    protected int readChar(LineNumberReader in) throws IOException {
        return in.read();
    }

    protected String readLine(LineNumberReader in) throws IOException {
        return in.readLine();
    }

    public FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    public FTPTransferType getType() {
        return this.transferType;
    }

    public void setType(FTPTransferType type) throws IOException, FTPException {
        this.checkConnection(true);
        String typeStr = FTPTransferType.ASCII_CHAR;
        if (type.equals(FTPTransferType.BINARY)) {
            typeStr = FTPTransferType.BINARY_CHAR;
        }
        FTPReply reply = this.control.sendCommand("TYPE " + typeStr);
        this.lastValidReply = this.control.validateReply(reply, "200");
        this.transferType = type;
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        String[] validCodes = new String[]{"200", "250"};
        FTPReply reply = this.control.sendCommand("DELE " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void rename(String from, String to) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("RNFR " + from);
        this.lastValidReply = this.control.validateReply(reply, "350");
        reply = this.control.sendCommand("RNTO " + to);
        this.lastValidReply = this.control.validateReply(reply, "250");
    }

    public void rmdir(String dir2) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("RMD " + dir2);
        String[] validCodes = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void mkdir(String dir2) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("MKD " + dir2);
        String[] validCodes = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public void chdir(String dir2) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("CWD " + dir2);
        this.lastValidReply = this.control.validateReply(reply, "250");
    }

    public void cdup() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("CDUP");
        String[] validCodes = new String[]{"200", "250"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    public Date modtime(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("MDTM " + remoteFile);
        this.lastValidReply = this.control.validateReply(reply, "213");
        Date ts = this.tsFormat.parse(this.lastValidReply.getReplyText(), new ParsePosition(0));
        return ts;
    }

    public String pwd() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(reply, "257");
        String text = this.lastValidReply.getReplyText();
        int start = text.indexOf(34);
        int end = text.lastIndexOf(34);
        if (start >= 0 && end > start) {
            return text.substring(start + 1, end);
        }
        return text;
    }

    public String[] features() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("FEAT");
        String[] validCodes = new String[]{"211", "500", "502"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        if (this.lastValidReply.getReplyCode().equals("211")) {
            return this.lastValidReply.getReplyData();
        }
        throw new FTPException(reply);
    }

    public String system() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("SYST");
        String[] validCodes = new String[]{"200", "213", "215"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    public void noOperation() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("NOOP");
        this.lastValidReply = this.control.validateReply(reply, "200");
    }

    public String help(String command) throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("HELP " + command);
        String[] validCodes = new String[]{"211", "214"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    protected void abort() throws IOException, FTPException {
        this.checkConnection(true);
        FTPReply reply = this.control.sendCommand("ABOR");
        String[] validCodes = new String[]{"426", "226"};
        this.lastValidReply = this.control.validateReply(reply, validCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException, FTPException {
        this.checkConnection(true);
        this.fileFactory = null;
        try {
            FTPReply reply = this.control.sendCommand("QUIT");
            String[] validCodes = new String[]{"221", "226"};
            this.lastValidReply = this.control.validateReply(reply, validCodes);
        }
        finally {
            this.control.logout();
            this.control = null;
        }
    }
}

