/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class VMSFileParser
extends FTPFileParser {
    public static String cvsId = "@(#)$Id: VMSFileParser.java,v 1.1 2005/06/03 11:26:13 bruceb Exp $";
    private static final String DIR = ".DIR";
    private static final String HDR = "Directory";
    private static final String TOTAL = "Total";
    private final int BLOCKSIZE = 524288;
    private static final int MIN_EXPECTED_FIELD_COUNT = 4;
    private SimpleDateFormat formatter1;
    private SimpleDateFormat formatter2;

    public VMSFileParser() {
        this.setLocale(Locale.getDefault());
    }

    public FTPFile parse(String raw) throws ParseException {
        String tstExtnsn;
        String[] fields = this.split(raw);
        if (fields.length <= 0) {
            return null;
        }
        if (fields.length >= 2 && fields[0].compareTo(HDR) == 0) {
            return null;
        }
        if (fields.length > 0 && fields[0].compareTo(TOTAL) == 0) {
            return null;
        }
        if (fields.length < 4) {
            return null;
        }
        String name = fields[0];
        int semiPos = name.lastIndexOf(59);
        if (semiPos <= 0) {
            throw new ParseException("File version number not found in name '" + name + "'", 0);
        }
        name = name.substring(0, semiPos);
        String afterSemi = fields[0].substring(semiPos + 1);
        try {
            Integer.parseInt(afterSemi);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        boolean isDir = false;
        if (semiPos < 0) {
            semiPos = fields[0].length();
        }
        if (semiPos > 4 && (tstExtnsn = fields[0].substring(semiPos - 4, semiPos)).compareTo(DIR) == 0) {
            isDir = true;
            name = name.substring(0, semiPos - 4);
        }
        int slashPos = fields[1].indexOf(47);
        String sizeUsed = fields[1];
        if (slashPos > 0) {
            sizeUsed = fields[1].substring(0, slashPos);
        }
        long size = Long.parseLong(sizeUsed) * 524288L;
        Date lastModified = null;
        try {
            lastModified = this.formatter1.parse(fields[2] + " " + fields[3]);
        }
        catch (ParseException ex) {
            lastModified = this.formatter2.parse(fields[2] + " " + fields[3]);
        }
        String group = null;
        String owner = null;
        if (fields.length >= 5 && fields[4].charAt(0) == '[' && fields[4].charAt(fields[4].length() - 1) == ']') {
            int commaPos = fields[4].indexOf(44);
            if (commaPos < 0) {
                throw new ParseException("Unable to parse [group,owner] field '" + fields[4] + "'", 0);
            }
            group = fields[4].substring(1, commaPos);
            owner = fields[4].substring(commaPos + 1, fields[4].length() - 1);
        }
        String permissions = null;
        if (fields.length >= 6 && fields[5].charAt(0) == '(' && fields[5].charAt(fields[5].length() - 1) == ')') {
            permissions = fields[5].substring(1, fields[5].length() - 2);
        }
        FTPFile file = new FTPFile(2, raw, name, size, isDir, lastModified);
        file.setGroup(group);
        file.setOwner(owner);
        file.setPermissions(permissions);
        return file;
    }

    public void setLocale(Locale locale) {
        this.formatter1 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", locale);
        this.formatter2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm", locale);
    }
}

