/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class WindowsFileParser
extends FTPFileParser {
    public static String cvsId = "@(#)$Id: WindowsFileParser.java,v 1.10 2005/06/03 11:26:25 bruceb Exp $";
    private SimpleDateFormat formatter;
    private static final String DIR = "<DIR>";
    private static final int MIN_EXPECTED_FIELD_COUNT = 4;

    public WindowsFileParser() {
        this.setLocale(Locale.getDefault());
    }

    public void setLocale(Locale locale) {
        this.formatter = new SimpleDateFormat("MM-dd-yy hh:mma", locale);
    }

    public FTPFile parse(String raw) throws ParseException {
        String[] fields = this.split(raw);
        if (fields.length < 4) {
            throw new ParseException("Unexpected number of fields: " + fields.length, 0);
        }
        Date lastModified = this.formatter.parse(fields[0] + " " + fields[1]);
        boolean isDir = false;
        long size = 0L;
        if (fields[2].equalsIgnoreCase(DIR)) {
            isDir = true;
        } else {
            try {
                size = Long.parseLong(fields[2]);
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Failed to parse size: " + fields[2], 0);
            }
        }
        int pos = 0;
        boolean ok = true;
        for (int i2 = 0; i2 < 3; ++i2) {
            if ((pos = raw.indexOf(fields[i2], pos)) < 0) {
                ok = false;
                break;
            }
            pos += fields[i2].length();
        }
        if (ok) {
            String name = raw.substring(pos).trim();
            return new FTPFile(0, raw, name, size, isDir, lastModified);
        }
        throw new ParseException("Failed to retrieve name: " + raw, 0);
    }
}

