/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.debug;

import com.enterprisedt.util.debug.Appender;
import com.enterprisedt.util.debug.Level;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class Logger {
    public static String cvsId = "@(#)$Id: Logger.java,v 1.8 2005/02/04 12:29:08 bruceb Exp $";
    private static Level globalLevel;
    private SimpleDateFormat format = new SimpleDateFormat("d MMM yyyy HH:mm:ss.S");
    private static Hashtable loggers;
    private static Vector appenders;
    private boolean useLog4j = false;
    private Date ts = new Date();
    private String clazz;
    private Method[][] methods = null;
    private Object logger = null;
    private Object[] argsPlain = new Object[1];
    private Object[] argsThrowable = new Object[2];

    private Logger(String clazz, boolean uselog4j) {
        this.clazz = clazz;
        this.useLog4j = uselog4j;
        if (uselog4j) {
            this.setupLog4j();
        }
    }

    private void setupLog4j() {
        this.methods = new Method[5][2];
        try {
            Class<?> log4jLogger = Class.forName("org.apache.log4j.Logger");
            Class[] args = new Class[]{String.class};
            Method getLogger = log4jLogger.getMethod("getLogger", args);
            Object[] invokeArgs = new Object[]{this.clazz};
            this.logger = getLogger.invoke(null, invokeArgs);
            Class[] plainArgs = new Class[]{Object.class};
            Class[] throwableArgs = new Class[]{Object.class, Throwable.class};
            this.methods[0][0] = log4jLogger.getMethod("fatal", plainArgs);
            this.methods[0][1] = log4jLogger.getMethod("fatal", throwableArgs);
            this.methods[1][0] = log4jLogger.getMethod("error", plainArgs);
            this.methods[1][1] = log4jLogger.getMethod("error", throwableArgs);
            this.methods[2][0] = log4jLogger.getMethod("warn", plainArgs);
            this.methods[2][1] = log4jLogger.getMethod("warn", throwableArgs);
            this.methods[3][0] = log4jLogger.getMethod("info", plainArgs);
            this.methods[3][1] = log4jLogger.getMethod("info", throwableArgs);
            this.methods[4][0] = log4jLogger.getMethod("debug", plainArgs);
            this.methods[4][1] = log4jLogger.getMethod("debug", throwableArgs);
        }
        catch (Exception ex) {
            this.useLog4j = false;
            this.error("Failed to initialize log4j logging", ex);
        }
    }

    public static void setLevel(Level level) {
        globalLevel = level;
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String clazz) {
        Logger logger = (Logger)loggers.get(clazz);
        if (logger == null) {
            boolean useLog4j = false;
            try {
                String log4j = System.getProperty("edtftp.log.log4j");
                if (log4j != null && log4j.equalsIgnoreCase("true")) {
                    useLog4j = true;
                }
            }
            catch (SecurityException ex) {
                System.out.println("Could not read property 'edtftp.log.log4j' due to security permissions");
            }
            logger = new Logger(clazz, useLog4j);
            loggers.put(clazz, logger);
        }
        return logger;
    }

    public static void addAppender(Appender newAppender) {
        appenders.addElement(newAppender);
    }

    public static void shutdown() {
        for (int i2 = 0; i2 < appenders.size(); ++i2) {
            Appender a2 = (Appender)appenders.elementAt(i2);
            a2.close();
        }
    }

    public void log(Level level, String message, Throwable t2) {
        if (this.useLog4j) {
            this.log4jLog(level, message, t2);
        } else if (globalLevel.isGreaterOrEqual(level)) {
            this.ourLog(level, message, t2);
        }
    }

    private void log4jLog(Level level, String message, Throwable t2) {
        Object[] args = null;
        int pos = -1;
        if (t2 == null) {
            args = this.argsPlain;
            pos = 0;
        } else {
            args = this.argsThrowable;
            args[1] = t2;
            pos = 1;
        }
        args[0] = message;
        Method method = this.methods[level.getLevel()][pos];
        try {
            method.invoke(this.logger, args);
        }
        catch (Exception ex) {
            this.ourLog(Level.ERROR, "Failed to invoke log4j method", ex);
            this.ourLog(level, message, t2);
        }
    }

    private void ourLog(Level level, String message, Throwable t2) {
        this.ts.setTime(System.currentTimeMillis());
        String stamp = this.format.format(this.ts);
        StringBuffer buf = new StringBuffer(level.toString());
        buf.append(" [").append(this.clazz).append("] ").append(stamp).append(" : ").append(message);
        if (t2 != null) {
            buf.append(" : ").append(t2.getMessage());
        }
        if (appenders.size() == 0) {
            System.out.println(buf.toString());
            if (t2 != null) {
                t2.printStackTrace(System.out);
            }
        } else {
            for (int i2 = 0; i2 < appenders.size(); ++i2) {
                Appender a2 = (Appender)appenders.elementAt(i2);
                a2.log(buf.toString());
                if (t2 == null) continue;
                a2.log(t2);
            }
        }
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void info(String message, Throwable t2) {
        this.log(Level.INFO, message, t2);
    }

    public void warn(String message) {
        this.log(Level.WARN, message, null);
    }

    public void warn(String message, Throwable t2) {
        this.log(Level.WARN, message, t2);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, null);
    }

    public void error(String message, Throwable t2) {
        this.log(Level.ERROR, message, t2);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message, null);
    }

    public void fatal(String message, Throwable t2) {
        this.log(Level.FATAL, message, t2);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, null);
    }

    public void debug(String message, Throwable t2) {
        this.log(Level.DEBUG, message, t2);
    }

    public boolean isEnabledFor(Level level) {
        return globalLevel.isGreaterOrEqual(level);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(Level.INFO);
    }

    static {
        loggers = new Hashtable(10);
        appenders = new Vector(2);
        String level = Level.OFF.toString();
        try {
            System.getProperty("edtftp.log.level", Level.OFF.toString());
        }
        catch (SecurityException ex) {
            System.out.println("Could not read property 'edtftp.log.level' due to security permissions");
        }
        globalLevel = Level.getLevel(level);
    }
}

