/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.RequestSignal;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public abstract class Channel
implements Runnable {
    static int index = 0;
    private static Vector pool = new Vector();
    int id;
    int recipient = -1;
    byte[] type = "foo".getBytes();
    int lwsize_max;
    int lwsize = this.lwsize_max = 0x100000;
    int lmpsize = 16384;
    int rwsize = 0;
    int rmpsize = 0;
    IO io = null;
    Thread thread = null;
    boolean eof_local = false;
    boolean eof_remote = false;
    boolean close = false;
    boolean connected = false;
    int exitstatus = -1;
    int reply = 0;
    Session session;

    static Channel getChannel(String string) {
        if (string.equals("session")) {
            return new ChannelSession();
        }
        if (string.equals("shell")) {
            return new ChannelShell();
        }
        if (string.equals("exec")) {
            return new ChannelExec();
        }
        if (string.equals("x11")) {
            return new ChannelX11();
        }
        if (string.equals("direct-tcpip")) {
            return new ChannelDirectTCPIP();
        }
        if (string.equals("forwarded-tcpip")) {
            return new ChannelForwardedTCPIP();
        }
        if (string.equals("sftp")) {
            return new ChannelSftp();
        }
        if (string.equals("subsystem")) {
            return new ChannelSubsystem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Channel getChannel(int n2, Session session) {
        Vector vector = pool;
        synchronized (vector) {
            int n3 = 0;
            while (n3 < pool.size()) {
                Channel channel = (Channel)pool.elementAt(n3);
                if (channel.id == n2 && channel.session == session) {
                    return channel;
                }
                ++n3;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void del(Channel channel) {
        Vector vector = pool;
        synchronized (vector) {
            pool.removeElement(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel() {
        Vector vector = pool;
        synchronized (vector) {
            this.id = index++;
            pool.addElement(this);
        }
    }

    void setRecipient(int n2) {
        this.recipient = n2;
    }

    int getRecipient() {
        return this.recipient;
    }

    void init() {
    }

    public void connect() throws JSchException {
        block8: {
            if (!this.session.isConnected()) {
                throw new JSchException("session is down");
            }
            try {
                Buffer buffer = new Buffer(100);
                Packet packet = new Packet(buffer);
                packet.reset();
                buffer.putByte((byte)90);
                buffer.putString(this.type);
                buffer.putInt(this.id);
                buffer.putInt(this.lwsize);
                buffer.putInt(this.lmpsize);
                this.session.write(packet);
                int n2 = 1000;
                while (this.getRecipient() == -1 && this.session.isConnected() && n2 > 0) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --n2;
                }
                if (!this.session.isConnected()) {
                    throw new JSchException("session is down");
                }
                if (n2 == 0) {
                    throw new JSchException("channel is not opened.");
                }
                this.connected = true;
                this.start();
            }
            catch (Exception exception) {
                this.connected = false;
                if (!(exception instanceof JSchException)) break block8;
                throw (JSchException)exception;
            }
        }
    }

    public void setXForwarding(boolean bl2) {
    }

    public void start() throws JSchException {
    }

    public boolean isEOF() {
        return this.eof_remote;
    }

    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getInt());
        this.setRemotePacketSize(buffer.getInt());
    }

    public void setInputStream(InputStream inputStream) {
        this.io.setInputStream(inputStream, false);
    }

    public void setInputStream(InputStream inputStream, boolean bl2) {
        this.io.setInputStream(inputStream, bl2);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.io.setOutputStream(outputStream, false);
    }

    public void setOutputStream(OutputStream outputStream, boolean bl2) {
        this.io.setOutputStream(outputStream, bl2);
    }

    public void setExtOutputStream(OutputStream outputStream) {
        this.io.setExtOutputStream(outputStream, false);
    }

    public void setExtOutputStream(OutputStream outputStream, boolean bl2) {
        this.io.setExtOutputStream(outputStream, bl2);
    }

    public InputStream getInputStream() throws IOException {
        MyPipedInputStream myPipedInputStream = new MyPipedInputStream(32768);
        this.io.setOutputStream(new PassiveOutputStream(myPipedInputStream), false);
        return myPipedInputStream;
    }

    public InputStream getExtInputStream() throws IOException {
        MyPipedInputStream myPipedInputStream = new MyPipedInputStream(32768);
        this.io.setExtOutputStream(new PassiveOutputStream(myPipedInputStream), false);
        return myPipedInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        this.io.setInputStream(new PassiveInputStream(pipedOutputStream, 32768), false);
        return pipedOutputStream;
    }

    void setLocalWindowSizeMax(int n2) {
        this.lwsize_max = n2;
    }

    void setLocalWindowSize(int n2) {
        this.lwsize = n2;
    }

    void setLocalPacketSize(int n2) {
        this.lmpsize = n2;
    }

    synchronized void setRemoteWindowSize(int n2) {
        this.rwsize = n2;
    }

    synchronized void addRemoteWindowSize(int n2) {
        this.rwsize += n2;
    }

    void setRemotePacketSize(int n2) {
        this.rmpsize = n2;
    }

    public void run() {
    }

    void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.io.put(byArray, n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void write_ext(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.io.put_ext(byArray, n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void eof_remote() {
        this.eof_remote = true;
        try {
            if (this.io.out != null) {
                this.io.out.close();
                this.io.out = null;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void eof() {
        if (this.close) {
            return;
        }
        if (this.eof_local) {
            return;
        }
        this.eof_local = true;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)96);
            buffer.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        if (this.close) {
            return;
        }
        this.close = true;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)97);
            buffer.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disconnect(Session session) {
        int n2;
        Channel[] channelArray = null;
        int n3 = 0;
        Vector vector = pool;
        synchronized (vector) {
            channelArray = new Channel[pool.size()];
            n2 = 0;
            while (n2 < pool.size()) {
                try {
                    Channel channel = (Channel)pool.elementAt(n2);
                    if (channel.session == session) {
                        channelArray[n3++] = channel;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n3) {
            channelArray[n2].disconnect();
            ++n2;
        }
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.close();
        this.eof_local = true;
        this.eof_remote = true;
        this.thread = null;
        try {
            if (this.io != null) {
                this.io.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.io = null;
        Channel.del(this);
    }

    public boolean isConnected() {
        if (this.session != null) {
            return this.session.isConnected() && this.connected;
        }
        return false;
    }

    public void sendSignal(String string) throws Exception {
        RequestSignal requestSignal = new RequestSignal();
        requestSignal.setSignal(string);
        requestSignal.request(this.session, this);
    }

    void setExitStatus(int n2) {
        this.exitstatus = n2;
    }

    public int getExitStatus() {
        return this.exitstatus;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public int getId() {
        return this.id;
    }

    class PassiveOutputStream
    extends PipedOutputStream {
        PassiveOutputStream(PipedInputStream pipedInputStream) throws IOException {
            super(pipedInputStream);
        }
    }

    class PassiveInputStream
    extends MyPipedInputStream {
        PipedOutputStream out;

        PassiveInputStream(PipedOutputStream pipedOutputStream, int n2) throws IOException {
            super(pipedOutputStream, n2);
            this.out = pipedOutputStream;
        }

        PassiveInputStream(PipedOutputStream pipedOutputStream) throws IOException {
            super(pipedOutputStream);
            this.out = pipedOutputStream;
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }

    class MyPipedInputStream
    extends PipedInputStream {
        MyPipedInputStream() throws IOException {
        }

        MyPipedInputStream(int n2) throws IOException {
            this.buffer = new byte[n2];
        }

        MyPipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
            super(pipedOutputStream);
        }

        MyPipedInputStream(PipedOutputStream pipedOutputStream, int n2) throws IOException {
            super(pipedOutputStream);
            this.buffer = new byte[n2];
        }
    }
}

