/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.DH;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SignatureDSA;
import com.jcraft.jsch.SignatureRSA;

public class DHGEX
extends KeyExchange {
    static final int SSH_MSG_KEX_DH_GEX_GROUP = 31;
    static final int SSH_MSG_KEX_DH_GEX_INIT = 32;
    static final int SSH_MSG_KEX_DH_GEX_REPLY = 33;
    static int min = 1024;
    static int preferred = 1024;
    static int max = 1024;
    static final int RSA = 0;
    static final int DSS = 1;
    private int type = 0;
    private int state;
    DH dh;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    private Buffer buf;
    private Packet packet;
    private byte[] p;
    private byte[] g;
    private byte[] e;
    private byte[] f;

    public void init(Session session, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws Exception {
        Class<?> clazz;
        this.session = session;
        this.V_S = byArray;
        this.V_C = byArray2;
        this.I_S = byArray3;
        this.I_C = byArray4;
        try {
            clazz = Class.forName(session.getConfig("sha-1"));
            this.sha = (HASH)clazz.newInstance();
            this.sha.init();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        try {
            clazz = Class.forName(session.getConfig("dh"));
            this.dh = (DH)clazz.newInstance();
            this.dh.init();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.packet.reset();
        this.buf.putByte((byte)34);
        this.buf.putInt(min);
        this.buf.putInt(preferred);
        this.buf.putInt(max);
        session.write(this.packet);
        this.state = 31;
    }

    public boolean next(Buffer buffer) throws Exception {
        switch (this.state) {
            case 31: {
                buffer.getInt();
                buffer.getByte();
                int n2 = buffer.getByte();
                if (n2 != 31) {
                    System.err.println("type: must be 31 " + n2);
                    return false;
                }
                this.p = buffer.getMPInt();
                this.g = buffer.getMPInt();
                this.dh.setP(this.p);
                this.dh.setG(this.g);
                this.e = this.dh.getE();
                this.packet.reset();
                this.buf.putByte((byte)32);
                this.buf.putMPInt(this.e);
                this.session.write(this.packet);
                this.state = 33;
                return true;
            }
            case 33: {
                int n3 = buffer.getInt();
                n3 = buffer.getByte();
                n3 = buffer.getByte();
                if (n3 != 33) {
                    System.err.println("type: must be 33 " + n3);
                    return false;
                }
                this.K_S = buffer.getString();
                byte[] byArray = buffer.getMPInt();
                byte[] byArray2 = buffer.getString();
                this.dh.setF(byArray);
                this.K = this.dh.getK();
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putInt(min);
                this.buf.putInt(preferred);
                this.buf.putInt(max);
                this.buf.putMPInt(this.p);
                this.buf.putMPInt(this.g);
                this.buf.putMPInt(this.e);
                this.buf.putMPInt(byArray);
                this.buf.putMPInt(this.K);
                byte[] byArray3 = new byte[this.buf.getLength()];
                this.buf.getByte(byArray3);
                this.sha.update(byArray3, 0, byArray3.length);
                this.H = this.sha.digest();
                int n4 = 0;
                n3 = 0;
                n3 = this.K_S[n4++] << 24 & 0xFF000000 | this.K_S[n4++] << 16 & 0xFF0000 | this.K_S[n4++] << 8 & 0xFF00 | this.K_S[n4++] & 0xFF;
                String string = new String(this.K_S, n4, n3);
                n4 += n3;
                boolean bl2 = false;
                if (string.equals("ssh-rsa")) {
                    this.type = 0;
                    n3 = this.K_S[n4++] << 24 & 0xFF000000 | this.K_S[n4++] << 16 & 0xFF0000 | this.K_S[n4++] << 8 & 0xFF00 | this.K_S[n4++] & 0xFF;
                    byte[] byArray4 = new byte[n3];
                    System.arraycopy(this.K_S, n4, byArray4, 0, n3);
                    n4 += n3;
                    byte[] byArray5 = byArray4;
                    n3 = this.K_S[n4++] << 24 & 0xFF000000 | this.K_S[n4++] << 16 & 0xFF0000 | this.K_S[n4++] << 8 & 0xFF00 | this.K_S[n4++] & 0xFF;
                    byArray4 = new byte[n3];
                    System.arraycopy(this.K_S, n4, byArray4, 0, n3);
                    n4 += n3;
                    byte[] byArray6 = byArray4;
                    SignatureRSA signatureRSA = null;
                    try {
                        Class<?> clazz = Class.forName(this.session.getConfig("signature.rsa"));
                        signatureRSA = (SignatureRSA)clazz.newInstance();
                        signatureRSA.init();
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                    signatureRSA.setPubKey(byArray5, byArray6);
                    signatureRSA.update(this.H);
                    bl2 = signatureRSA.verify(byArray2);
                } else if (string.equals("ssh-dss")) {
                    byte[] byArray7 = null;
                    this.type = 1;
                    n3 = this.K_S[n4++] << 24 & 0xFF000000 | this.K_S[n4++] << 16 & 0xFF0000 | this.K_S[n4++] << 8 & 0xFF00 | this.K_S[n4++] & 0xFF;
                    byte[] byArray8 = new byte[n3];
                    System.arraycopy(this.K_S, n4, byArray8, 0, n3);
                    n4 += n3;
                    this.p = byArray8;
                    n3 = this.K_S[n4++] << 24 & 0xFF000000 | this.K_S[n4++] << 16 & 0xFF0000 | this.K_S[n4++] << 8 & 0xFF00 | this.K_S[n4++] & 0xFF;
                    byArray8 = new byte[n3];
                    System.arraycopy(this.K_S, n4, byArray8, 0, n3);
                    n4 += n3;
                    byArray7 = byArray8;
                    n3 = this.K_S[n4++] << 24 & 0xFF000000 | this.K_S[n4++] << 16 & 0xFF0000 | this.K_S[n4++] << 8 & 0xFF00 | this.K_S[n4++] & 0xFF;
                    byArray8 = new byte[n3];
                    System.arraycopy(this.K_S, n4, byArray8, 0, n3);
                    n4 += n3;
                    this.g = byArray8;
                    n3 = this.K_S[n4++] << 24 & 0xFF000000 | this.K_S[n4++] << 16 & 0xFF0000 | this.K_S[n4++] << 8 & 0xFF00 | this.K_S[n4++] & 0xFF;
                    byArray8 = new byte[n3];
                    System.arraycopy(this.K_S, n4, byArray8, 0, n3);
                    n4 += n3;
                    byArray = byArray8;
                    SignatureDSA signatureDSA = null;
                    try {
                        Class<?> clazz = Class.forName(this.session.getConfig("signature.dss"));
                        signatureDSA = (SignatureDSA)clazz.newInstance();
                        signatureDSA.init();
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                    signatureDSA.setPubKey(byArray, this.p, byArray7, this.g);
                    signatureDSA.update(this.H);
                    bl2 = signatureDSA.verify(byArray2);
                } else {
                    System.out.println("unknow alg");
                }
                this.state = 0;
                return bl2;
            }
        }
        return false;
    }

    public String getKeyType() {
        if (this.type == 1) {
            return "DSA";
        }
        return "RSA";
    }

    public int getState() {
        return this.state;
    }
}

