/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SignatureDSA;
import com.jcraft.jsch.SignatureRSA;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;

class IdentityFile
implements Identity {
    String identity;
    byte[] key;
    byte[] iv;
    private JSch jsch;
    private HASH hash;
    private byte[] encoded_data;
    private Cipher cipher;
    private byte[] P_array;
    private byte[] Q_array;
    private byte[] G_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private byte[] n_array;
    private byte[] e_array;
    private byte[] d_array;
    private String algname = "ssh-rsa";
    private static final int ERROR = 0;
    private static final int RSA = 1;
    private static final int DSS = 2;
    private static final int UNKNOWN = 3;
    private static final int OPENSSH = 0;
    private static final int FSECURE = 1;
    private static final int PUTTY = 2;
    private int type = 0;
    private int keytype = 0;
    private byte[] publickeyblob = null;
    private boolean encrypted = true;

    IdentityFile(String string, JSch jSch) throws JSchException {
        this.identity = string;
        this.jsch = jSch;
        try {
            int n2;
            int n3;
            Class<?> clazz = Class.forName(jSch.getConfig("3des-cbc"));
            this.cipher = (Cipher)clazz.newInstance();
            this.key = new byte[this.cipher.getBlockSize()];
            this.iv = new byte[this.cipher.getIVSize()];
            clazz = Class.forName(jSch.getConfig("md5"));
            this.hash = (HASH)clazz.newInstance();
            this.hash.init();
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[(int)file.length()];
            int n4 = fileInputStream.read(byArray, 0, byArray.length);
            fileInputStream.close();
            int n5 = 0;
            while (n5 < n4) {
                if (byArray[n5] == 66 && byArray[n5 + 1] == 69 && byArray[n5 + 2] == 71 && byArray[n5 + 3] == 73) {
                    if (byArray[n5 += 6] == 68 && byArray[n5 + 1] == 83 && byArray[n5 + 2] == 65) {
                        this.type = 2;
                    } else if (byArray[n5] == 82 && byArray[n5 + 1] == 83 && byArray[n5 + 2] == 65) {
                        this.type = 1;
                    } else if (byArray[n5] == 83 && byArray[n5 + 1] == 83 && byArray[n5 + 2] == 72) {
                        this.type = 3;
                        this.keytype = 1;
                    } else {
                        throw new JSchException("invaid privatekey: " + string);
                    }
                    n5 += 3;
                    continue;
                }
                if (byArray[n5] == 67 && byArray[n5 + 1] == 66 && byArray[n5 + 2] == 67 && byArray[n5 + 3] == 44) {
                    n5 += 4;
                    n3 = 0;
                    while (n3 < this.iv.length) {
                        this.iv[n3] = (byte)((this.a2b(byArray[n5++]) << 4 & 0xF0) + (this.a2b(byArray[n5++]) & 0xF));
                        ++n3;
                    }
                    continue;
                }
                if (byArray[n5] == 13 && n5 + 1 < byArray.length && byArray[n5 + 1] == 10) {
                    ++n5;
                    continue;
                }
                if (byArray[n5] == 10 && n5 + 1 < byArray.length) {
                    if (byArray[n5 + 1] == 10) {
                        n5 += 2;
                        break;
                    }
                    if (byArray[n5 + 1] == 13 && n5 + 2 < byArray.length && byArray[n5 + 2] == 10) {
                        n5 += 3;
                        break;
                    }
                    n3 = 0;
                    n2 = n5 + 1;
                    while (n2 < byArray.length) {
                        if (byArray[n2] == 10) break;
                        if (byArray[n2] == 58) {
                            n3 = 1;
                            break;
                        }
                        ++n2;
                    }
                    if (n3 == 0) {
                        ++n5;
                        this.encrypted = false;
                        break;
                    }
                }
                ++n5;
            }
            if (this.type == 0) {
                throw new JSchException("invaid privatekey: " + string);
            }
            n3 = n5;
            while (n5 < n4) {
                if (byArray[n5] == 10) {
                    n2 = byArray[n5 - 1] == 13 ? 1 : 0;
                    System.arraycopy(byArray, n5 + 1, byArray, n5 - (n2 != 0 ? 1 : 0), n4 - n5 - 1 - (n2 != 0 ? 1 : 0));
                    if (n2 != 0) {
                        --n4;
                    }
                    --n4;
                    continue;
                }
                if (byArray[n5] == 45) break;
                ++n5;
            }
            this.encoded_data = Util.fromBase64(byArray, n3, n5 - n3);
            if (this.encoded_data.length > 4 && this.encoded_data[0] == 63 && this.encoded_data[1] == 111 && this.encoded_data[2] == -7 && this.encoded_data[3] == -21) {
                Buffer buffer = new Buffer(this.encoded_data);
                buffer.getInt();
                buffer.getInt();
                byte[] byArray2 = buffer.getString();
                byte[] byArray3 = buffer.getString();
                String string2 = new String(byArray3);
                if (string2.equals("3des-cbc")) {
                    buffer.getInt();
                    byte[] byArray4 = new byte[this.encoded_data.length - buffer.getOffSet()];
                    buffer.getByte(byArray4);
                    this.encoded_data = byArray4;
                    this.encrypted = true;
                    throw new JSchException("unknown privatekey format: " + string);
                }
                if (string2.equals("none")) {
                    buffer.getInt();
                    this.encrypted = false;
                    byte[] byArray5 = new byte[this.encoded_data.length - buffer.getOffSet()];
                    buffer.getByte(byArray5);
                    this.encoded_data = byArray5;
                }
            }
            try {
                file = new File(string + ".pub");
                fileInputStream = new FileInputStream(string + ".pub");
                byArray = new byte[(int)file.length()];
                n4 = fileInputStream.read(byArray, 0, byArray.length);
                fileInputStream.close();
            }
            catch (Exception exception) {
                return;
            }
            if (byArray.length > 4 && byArray[0] == 45 && byArray[1] == 45 && byArray[2] == 45 && byArray[3] == 45) {
                n5 = 0;
                while (byArray.length > ++n5 && byArray[n5] != 10) {
                }
                if (byArray.length <= n5) {
                    return;
                }
                while (true) {
                    if (byArray[n5] == 10) {
                        boolean bl2 = false;
                        int n6 = n5 + 1;
                        while (n6 < byArray.length) {
                            if (byArray[n6] == 10) break;
                            if (byArray[n6] == 58) {
                                bl2 = true;
                                break;
                            }
                            ++n6;
                        }
                        if (!bl2) break;
                    }
                    ++n5;
                }
                if (byArray.length <= ++n5) {
                    return;
                }
                n3 = n5;
                while (n5 < n4) {
                    if (byArray[n5] == 10) {
                        System.arraycopy(byArray, n5 + 1, byArray, n5, n4 - n5 - 1);
                        --n4;
                        continue;
                    }
                    if (byArray[n5] == 45) break;
                    ++n5;
                }
                this.publickeyblob = Util.fromBase64(byArray, n3, n5 - n3);
                if (this.type == 3) {
                    if (this.publickeyblob[8] == 100) {
                        this.type = 2;
                    } else if (this.publickeyblob[8] == 114) {
                        this.type = 1;
                    }
                }
            } else {
                if (byArray[0] != 115 || byArray[1] != 115 || byArray[2] != 104 || byArray[3] != 45) {
                    return;
                }
                n5 = 0;
                while (n5 < n4) {
                    if (byArray[n5] == 32) break;
                    ++n5;
                }
                if (++n5 >= n4) {
                    return;
                }
                n3 = n5;
                while (n5 < n4) {
                    if (byArray[n5] == 32) break;
                    ++n5;
                }
                this.publickeyblob = Util.fromBase64(byArray, n3, n5 - n3);
            }
        }
        catch (Exception exception) {
            System.out.println("Identity: " + exception);
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            throw new JSchException(exception.toString());
        }
    }

    public String getAlgName() {
        if (this.type == 1) {
            return "ssh-rsa";
        }
        return "ssh-dss";
    }

    public boolean setPassphrase(String string) throws JSchException {
        try {
            if (this.encrypted) {
                int n2;
                if (string == null) {
                    return false;
                }
                byte[] byArray = string.getBytes();
                int n3 = this.hash.getBlockSize();
                byte[] byArray2 = new byte[this.key.length / n3 * n3 + (this.key.length % n3 == 0 ? 0 : n3)];
                byte[] byArray3 = null;
                if (this.keytype == 0) {
                    n2 = 0;
                    while (n2 + n3 <= byArray2.length) {
                        if (byArray3 != null) {
                            this.hash.update(byArray3, 0, byArray3.length);
                        }
                        this.hash.update(byArray, 0, byArray.length);
                        this.hash.update(this.iv, 0, this.iv.length);
                        byArray3 = this.hash.digest();
                        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
                        n2 += byArray3.length;
                    }
                    System.arraycopy(byArray2, 0, this.key, 0, this.key.length);
                } else if (this.keytype == 1) {
                    n2 = 0;
                    while (n2 + n3 <= byArray2.length) {
                        if (byArray3 != null) {
                            this.hash.update(byArray3, 0, byArray3.length);
                        }
                        this.hash.update(byArray, 0, byArray.length);
                        byArray3 = this.hash.digest();
                        System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
                        n2 += byArray3.length;
                    }
                    System.arraycopy(byArray2, 0, this.key, 0, this.key.length);
                }
                if (byArray != null) {
                    n2 = 0;
                    while (n2 < byArray.length) {
                        byArray[n2] = 0;
                        ++n2;
                    }
                    byArray = null;
                }
            }
            if (this.decrypt()) {
                this.encrypted = false;
                return true;
            }
            this.prv_array = null;
            this.pub_array = null;
            this.G_array = null;
            this.Q_array = null;
            this.P_array = null;
            return false;
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            throw new JSchException(exception.toString());
        }
    }

    public byte[] getPublicKeyBlob() {
        if (this.publickeyblob != null) {
            return this.publickeyblob;
        }
        if (this.type == 1) {
            return this.getPublicKeyBlob_rsa();
        }
        return this.getPublicKeyBlob_dss();
    }

    byte[] getPublicKeyBlob_rsa() {
        if (this.e_array == null) {
            return null;
        }
        Buffer buffer = new Buffer("ssh-rsa".length() + 4 + this.e_array.length + 4 + this.n_array.length + 4);
        buffer.putString("ssh-rsa".getBytes());
        buffer.putString(this.e_array);
        buffer.putString(this.n_array);
        return buffer.buffer;
    }

    byte[] getPublicKeyBlob_dss() {
        if (this.P_array == null) {
            return null;
        }
        Buffer buffer = new Buffer("ssh-dss".length() + 4 + this.P_array.length + 4 + this.Q_array.length + 4 + this.G_array.length + 4 + this.pub_array.length + 4);
        buffer.putString("ssh-dss".getBytes());
        buffer.putString(this.P_array);
        buffer.putString(this.Q_array);
        buffer.putString(this.G_array);
        buffer.putString(this.pub_array);
        return buffer.buffer;
    }

    public byte[] getSignature(byte[] byArray) {
        if (this.type == 1) {
            return this.getSignature_rsa(byArray);
        }
        return this.getSignature_dss(byArray);
    }

    byte[] getSignature_rsa(byte[] byArray) {
        try {
            Class<?> clazz = Class.forName(this.jsch.getConfig("signature.rsa"));
            SignatureRSA signatureRSA = (SignatureRSA)clazz.newInstance();
            signatureRSA.init();
            signatureRSA.setPrvKey(this.d_array, this.n_array);
            signatureRSA.update(byArray);
            byte[] byArray2 = signatureRSA.sign();
            Buffer buffer = new Buffer("ssh-rsa".length() + 4 + byArray2.length + 4);
            buffer.putString("ssh-rsa".getBytes());
            buffer.putString(byArray2);
            return buffer.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    byte[] getSignature_dss(byte[] byArray) {
        try {
            Class<?> clazz = Class.forName(this.jsch.getConfig("signature.dss"));
            SignatureDSA signatureDSA = (SignatureDSA)clazz.newInstance();
            signatureDSA.init();
            signatureDSA.setPrvKey(this.prv_array, this.P_array, this.Q_array, this.G_array);
            signatureDSA.update(byArray);
            byte[] byArray2 = signatureDSA.sign();
            Buffer buffer = new Buffer("ssh-dss".length() + 4 + byArray2.length + 4);
            buffer.putString("ssh-dss".getBytes());
            buffer.putString(byArray2);
            return buffer.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean decrypt() {
        if (this.type == 1) {
            return this.decrypt_rsa();
        }
        return this.decrypt_dss();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean decrypt_rsa() {
        try {
            int n2;
            int n3;
            byte[] byArray;
            if (this.encrypted) {
                if (this.keytype == 0) {
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                } else {
                    if (this.keytype != 1) return false;
                    n3 = 0;
                    while (n3 < this.iv.length) {
                        this.iv[n3] = 0;
                        ++n3;
                    }
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                }
            } else {
                if (this.n_array != null) {
                    return true;
                }
                byArray = this.encoded_data;
            }
            if (this.keytype == 1) {
                Buffer buffer = new Buffer(byArray);
                int n4 = buffer.getInt();
                if (byArray.length != n4 + 4) {
                    return false;
                }
                this.e_array = buffer.getMPIntBits();
                this.d_array = buffer.getMPIntBits();
                this.n_array = buffer.getMPIntBits();
                byte[] byArray2 = buffer.getMPIntBits();
                byte[] byArray3 = buffer.getMPIntBits();
                byte[] byArray4 = buffer.getMPIntBits();
                return true;
            }
            n3 = 0;
            int n5 = 0;
            if (byArray[n3] != 48) {
                return false;
            }
            int n6 = ++n3;
            ++n3;
            n5 = byArray[n6] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            if (byArray[n3] != 2) {
                return false;
            }
            int n7 = ++n3;
            ++n3;
            n5 = byArray[n7] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            n3 += n5;
            int n8 = ++n3;
            ++n3;
            n5 = byArray[n8] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.n_array = new byte[n5];
            System.arraycopy(byArray, n3, this.n_array, 0, n5);
            n3 += n5;
            int n9 = ++n3;
            ++n3;
            n5 = byArray[n9] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.e_array = new byte[n5];
            System.arraycopy(byArray, n3, this.e_array, 0, n5);
            n3 += n5;
            int n10 = ++n3;
            ++n3;
            n5 = byArray[n10] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.d_array = new byte[n5];
            System.arraycopy(byArray, n3, this.d_array, 0, n5);
            n3 += n5;
            int n11 = ++n3;
            ++n3;
            n5 = byArray[n11] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            byte[] byArray5 = new byte[n5];
            System.arraycopy(byArray, n3, byArray5, 0, n5);
            n3 += n5;
            int n12 = ++n3;
            ++n3;
            n5 = byArray[n12] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            byte[] byArray6 = new byte[n5];
            System.arraycopy(byArray, n3, byArray6, 0, n5);
            n3 += n5;
            int n13 = ++n3;
            ++n3;
            n5 = byArray[n13] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            byte[] byArray7 = new byte[n5];
            System.arraycopy(byArray, n3, byArray7, 0, n5);
            n3 += n5;
            int n14 = ++n3;
            ++n3;
            n5 = byArray[n14] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            byte[] byArray8 = new byte[n5];
            System.arraycopy(byArray, n3, byArray8, 0, n5);
            n3 += n5;
            int n15 = ++n3;
            ++n3;
            n5 = byArray[n15] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            byte[] byArray9 = new byte[n5];
            System.arraycopy(byArray, n3, byArray9, 0, n5);
            n3 += n5;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean decrypt_dss() {
        try {
            int n2;
            int n3;
            byte[] byArray;
            if (this.encrypted) {
                if (this.keytype == 0) {
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                } else {
                    if (this.keytype != 1) return false;
                    n3 = 0;
                    while (n3 < this.iv.length) {
                        this.iv[n3] = 0;
                        ++n3;
                    }
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                }
            } else {
                if (this.P_array != null) {
                    return true;
                }
                byArray = this.encoded_data;
            }
            if (this.keytype == 1) {
                Buffer buffer = new Buffer(byArray);
                int n4 = buffer.getInt();
                if (byArray.length != n4 + 4) {
                    return false;
                }
                this.P_array = buffer.getMPIntBits();
                this.G_array = buffer.getMPIntBits();
                this.Q_array = buffer.getMPIntBits();
                this.pub_array = buffer.getMPIntBits();
                this.prv_array = buffer.getMPIntBits();
                return true;
            }
            n3 = 0;
            int n5 = 0;
            if (byArray[n3] != 48) {
                return false;
            }
            int n6 = ++n3;
            ++n3;
            n5 = byArray[n6] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            if (byArray[n3] != 2) {
                return false;
            }
            int n7 = ++n3;
            ++n3;
            n5 = byArray[n7] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            n3 += n5;
            int n8 = ++n3;
            ++n3;
            n5 = byArray[n8] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.P_array = new byte[n5];
            System.arraycopy(byArray, n3, this.P_array, 0, n5);
            n3 += n5;
            int n9 = ++n3;
            ++n3;
            n5 = byArray[n9] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.Q_array = new byte[n5];
            System.arraycopy(byArray, n3, this.Q_array, 0, n5);
            n3 += n5;
            int n10 = ++n3;
            ++n3;
            n5 = byArray[n10] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.G_array = new byte[n5];
            System.arraycopy(byArray, n3, this.G_array, 0, n5);
            n3 += n5;
            int n11 = ++n3;
            ++n3;
            n5 = byArray[n11] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.pub_array = new byte[n5];
            System.arraycopy(byArray, n3, this.pub_array, 0, n5);
            n3 += n5;
            int n12 = ++n3;
            ++n3;
            n5 = byArray[n12] & 0xFF;
            if ((n5 & 0x80) != 0) {
                n2 = n5 & 0x7F;
                n5 = 0;
                while (n2-- > 0) {
                    n5 = (n5 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.prv_array = new byte[n5];
            System.arraycopy(byArray, n3, this.prv_array, 0, n5);
            n3 += n5;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public String getName() {
        return this.identity;
    }

    private int writeSEQUENCE(byte[] byArray, int n2, int n3) {
        byArray[n2++] = 48;
        n2 = this.writeLength(byArray, n2, n3);
        return n2;
    }

    private int writeINTEGER(byte[] byArray, int n2, byte[] byArray2) {
        byArray[n2++] = 2;
        n2 = this.writeLength(byArray, n2, byArray2.length);
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return n2 += byArray2.length;
    }

    /*
     * Unable to fully structure code
     */
    private int countLength(int var1_1) {
        var2_2 = 1;
        if (var1_1 > 127) ** GOTO lbl6
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var1_1 >>>= 8;
            ++var2_2;
lbl6:
            // 2 sources

            ** while (var1_1 > 0)
        }
lbl7:
        // 1 sources

        return var2_2;
    }

    private int writeLength(byte[] byArray, int n2, int n3) {
        int n4 = this.countLength(n3) - 1;
        if (n4 == 0) {
            byArray[n2++] = (byte)n3;
            return n2;
        }
        byArray[n2++] = (byte)(0x80 | n4);
        int n5 = n2 + n4;
        while (n4 > 0) {
            byArray[n2 + n4 - 1] = (byte)(n3 & 0xFF);
            n3 >>>= 8;
            --n4;
        }
        return n5;
    }

    private byte a2b(byte by2) {
        if (48 <= by2 && by2 <= 57) {
            return (byte)(by2 - 48);
        }
        if (97 <= by2 && by2 <= 122) {
            return (byte)(by2 - 97 + 10);
        }
        return (byte)(by2 - 65 + 10);
    }

    private byte b2a(byte by2) {
        if (0 <= by2 && by2 <= 9) {
            return (byte)(by2 + 48);
        }
        return (byte)(by2 - 10 + 65);
    }
}

