/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs;

import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSFactory;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import java.io.File;
import java.io.IOException;

public class RemoteFSBean
implements RemoteFS {
    private RemoteFS remoteFS = null;
    private boolean secure = false;

    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        this.getRemoteFS().connect(server, user, password);
    }

    public void createDirectory(String name) throws IOException, RemoteFSException {
        this.getRemoteFS().createDirectory(name);
    }

    public void disconnect() throws IOException, RemoteFSException {
        this.getRemoteFS().disconnect();
    }

    public String getDirectory() throws IOException, RemoteFSException {
        return this.getRemoteFS().getDirectory();
    }

    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        return this.getRemoteFS().getFiles();
    }

    public int getPort() throws RemoteFSException {
        return this.getRemoteFS().getPort();
    }

    private RemoteFS getRemoteFS() throws RemoteFSException {
        if (this.remoteFS == null) {
            this.remoteFS = !this.secure ? RemoteFSFactory.getRemoteFS("ftp") : RemoteFSFactory.getRemoteFS("sftp");
        }
        return this.remoteFS;
    }

    public boolean isConnected() throws RemoteFSException {
        return this.getRemoteFS().isConnected();
    }

    public boolean isForceUTF8() throws RemoteFSException {
        return this.getRemoteFS().isForceUTF8();
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.getRemoteFS().isPassiveMode();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void putFile(File file) throws IOException, RemoteFSException {
        this.getRemoteFS().putFile(file);
    }

    public void removeDirectory(String name) throws IOException, RemoteFSException {
        this.getRemoteFS().removeDirectory(name);
    }

    public void removeFile(String filename) throws IOException, RemoteFSException {
        this.getRemoteFS().removeFile(filename);
    }

    public void setDirectory(String directory) throws IOException, RemoteFSException {
        this.getRemoteFS().setDirectory(directory);
    }

    public void setForceUTF8(boolean force) throws RemoteFSException {
        this.getRemoteFS().setForceUTF8(force);
    }

    public void setPassiveMode(boolean mode) throws RemoteFSException {
        this.getRemoteFS().setPassiveMode(mode);
    }

    public void setPort(int port) throws RemoteFSException {
        this.getRemoteFS().setPort(port);
    }

    public void setProgressMonitor(RemoteFSProgressMonitor monitor) throws RemoteFSException {
        this.getRemoteFS().setProgressMonitor(monitor);
    }

    public void setSecure(boolean sec) {
        if (sec != this.secure) {
            this.remoteFS = null;
        }
        this.secure = sec;
    }

    public void testConnection(String server, String user, String password) throws IOException, RemoteFSException {
        this.connect(server, user, password);
        if (!this.isConnected()) {
            throw new RemoteFSException("Not connected to server");
        }
        this.disconnect();
        if (this.isConnected()) {
            throw new RemoteFSException("Still connected to server");
        }
    }

    public void toParentDirectory() throws RemoteFSException, IOException {
        this.getRemoteFS().toParentDirectory();
    }
}

