/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferType;
import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.ftp.FtpFile;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class FtpAdapter
implements RemoteFS {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private boolean connected = false;
    private FTPClient ftpClient = new FTPClient();

    public FtpAdapter() {
        try {
            this.ftpClient.setControlEncoding(DEFAULT_ENCODING);
            String ftpLocale = System.getProperty("ftp.locale");
            if (ftpLocale != null) {
                this.ftpClient.setParserLocale(new Locale(ftpLocale));
            } else {
                this.ftpClient.setParserLocale(Locale.ENGLISH);
            }
        }
        catch (FTPException ex) {
        }
    }

    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        try {
            this.ftpClient.setRemoteHost(server);
            this.ftpClient.connect();
            this.ftpClient.login(user, password);
            this.ftpClient.setType(FTPTransferType.BINARY);
            this.connected = true;
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void createDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.ftpClient.mkdir(name);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void disconnect() throws IOException, RemoteFSException {
        this.connected = false;
        try {
            this.ftpClient.quit();
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public String getDirectory() throws RemoteFSException, IOException {
        try {
            StringBuffer buf = new StringBuffer();
            String[] lines = this.ftpClient.dir();
            int i2 = 0;
            while (i2 < lines.length) {
                buf.append(lines[i2]);
                buf.append('\n');
                ++i2;
            }
            return buf.toString();
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        try {
            FTPFile[] files = this.ftpClient.dirDetails(".");
            RemoteFile[] finalFiles = new FtpFile[files.length];
            int i2 = 0;
            while (i2 < files.length) {
                String name = files[i2].getName();
                long size = files[i2].size();
                Date date = files[i2].lastModified();
                finalFiles[i2] = new FtpFile(name, size, date, files[i2].isDir());
                ++i2;
            }
            return finalFiles;
        }
        catch (ParseException e2) {
            throw new RemoteFSException(e2);
        }
        catch (FTPException e3) {
            throw new RemoteFSException(e3);
        }
    }

    public int getPort() {
        return this.ftpClient.getRemotePort();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isForceUTF8() {
        return "UTF-8".equals(this.ftpClient.getControlEncoding());
    }

    public boolean isPassiveMode() {
        return this.ftpClient.getConnectMode() == FTPConnectMode.PASV;
    }

    public void putFile(File file) throws IOException, RemoteFSException {
        try {
            this.ftpClient.put(file.getAbsolutePath(), file.getName());
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void removeDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.ftpClient.rmdir(name);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void removeFile(String filename) throws IOException, RemoteFSException {
        try {
            this.ftpClient.delete(filename);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void setDirectory(String directory) throws RemoteFSException, IOException {
        try {
            this.ftpClient.chdir(directory);
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }

    public void setForceUTF8(boolean force) {
        try {
            if (force) {
                this.ftpClient.setControlEncoding("UTF-8");
            } else {
                this.ftpClient.setControlEncoding(DEFAULT_ENCODING);
            }
        }
        catch (FTPException ex) {
        }
    }

    public void setPassiveMode(boolean passive) {
        if (passive) {
            this.ftpClient.setConnectMode(FTPConnectMode.PASV);
        } else {
            this.ftpClient.setConnectMode(FTPConnectMode.ACTIVE);
        }
    }

    public void setPort(int port) {
        try {
            this.ftpClient.setRemotePort(port);
        }
        catch (FTPException ex) {
        }
    }

    public void setProgressMonitor(final RemoteFSProgressMonitor monitor) {
        this.ftpClient.setProgressMonitor(new FTPProgressMonitor(){

            public void bytesTransferred(long count) {
                monitor.bytesTransferred(count);
            }
        });
    }

    public void toParentDirectory() throws IOException, RemoteFSException {
        try {
            this.ftpClient.cdup();
        }
        catch (FTPException ex) {
            throw new RemoteFSException(ex);
        }
    }
}

