/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;
import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.sftp.SftpFile;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SftpAdapter
implements RemoteFS {
    private ChannelSftp channelSftp = null;
    private boolean connected;
    private boolean forceUTF8;
    private SftpProgressMonitor monitor = null;
    private boolean passiveMode;
    private int port = 22;
    private Session session = null;

    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        if (!this.connected) {
            JSch jsch = new JSch();
            try {
                this.session = jsch.getSession(user, server, this.port);
                MyUserInfo ui = new MyUserInfo(password);
                this.session.setUserInfo(ui);
                this.session.connect();
                Channel channel = this.session.openChannel("sftp");
                channel.connect();
                this.channelSftp = (ChannelSftp)channel;
                this.connected = true;
            }
            catch (JSchException e2) {
                throw new RemoteFSException(e2);
            }
        }
    }

    public void createDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.channelSftp.mkdir(name);
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void disconnect() throws IOException, RemoteFSException {
        if (!this.connected) {
            throw new RemoteFSException("Not connected to remote server");
        }
        this.connected = false;
        this.session.disconnect();
    }

    public String getDirectory() throws RemoteFSException, IOException {
        return this.channelSftp.pwd();
    }

    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        try {
            Vector ls = this.channelSftp.ls(".");
            RemoteFile[] files = new SftpFile[ls.size()];
            int i2 = 0;
            while (i2 < ls.size()) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)ls.get(i2);
                files[i2] = new SftpFile(entry);
                ++i2;
            }
            return files;
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public int getPort() throws RemoteFSException {
        return this.port;
    }

    public boolean isConnected() throws RemoteFSException {
        return this.connected;
    }

    public boolean isForceUTF8() throws RemoteFSException {
        return this.forceUTF8;
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.passiveMode;
    }

    public void putFile(File file) throws IOException, RemoteFSException {
        String src = file.getAbsolutePath();
        String dest = ".";
        int mode = 0;
        try {
            if (this.monitor != null) {
                this.channelSftp.put(src, dest, this.monitor, mode);
            } else {
                this.channelSftp.put(src, dest, mode);
            }
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void removeDirectory(String name) throws IOException, RemoteFSException {
        try {
            this.channelSftp.rmdir(name);
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void removeFile(String filename) throws IOException, RemoteFSException {
        try {
            this.channelSftp.rm(filename);
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void setDirectory(String directory) throws RemoteFSException, IOException {
        try {
            this.channelSftp.cd(directory);
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public void setForceUTF8(boolean force) throws RemoteFSException {
        this.forceUTF8 = force;
    }

    public void setPassiveMode(boolean mode) throws RemoteFSException {
        this.passiveMode = mode;
    }

    public void setPort(int port) throws RemoteFSException {
        this.port = port;
    }

    public void setProgressMonitor(final RemoteFSProgressMonitor monitor) {
        this.monitor = new SftpProgressMonitor(){

            public boolean count(long long0) {
                monitor.bytesTransferred(long0);
                return true;
            }

            public void end() {
            }

            public void init(int int0, String string, String string2, long long3) {
            }
        };
    }

    public void toParentDirectory() throws RemoteFSException, IOException {
        try {
            this.channelSftp.cd("..");
        }
        catch (SftpException e2) {
            throw new RemoteFSException(e2);
        }
    }

    public static class MyUserInfo
    implements UserInfo {
        private String passwd;

        public MyUserInfo(String password) {
            this.passwd = password;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }
    }
}

