/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs.sftp;

import com.jcraft.jsch.ChannelSftp;
import info.cqs.remotefs.RemoteFile;
import java.util.Date;
import java.util.StringTokenizer;

public class SftpFile
extends RemoteFile {
    private int count;
    private String group;
    private String line;
    private String owner;
    private boolean parsed = false;
    private String permissions;

    public SftpFile(ChannelSftp.LsEntry entry) {
        this.name = entry.getFilename();
        this.line = entry.getLongname();
        this.parseUnixLine(this.line);
    }

    public Date getCreationDate() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return super.getCreationDate();
    }

    public Date getModificationDate() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return super.getModificationDate();
    }

    public boolean isDirectory() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return this.permissions.startsWith("d");
    }

    public boolean isFile() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return !this.permissions.startsWith("d");
    }

    private boolean isParsed() {
        return this.parsed;
    }

    private void parseUnixLine(String line) {
        Date d2;
        StringTokenizer st = new StringTokenizer(line, " ");
        this.permissions = st.nextToken();
        this.count = Integer.parseInt(st.nextToken());
        this.owner = st.nextToken();
        this.group = st.nextToken();
        this.size = Long.parseLong(st.nextToken());
        StringBuffer date = new StringBuffer();
        date.append(st.nextToken());
        date.append(" ").append(st.nextToken());
        date.append(" ").append(st.nextToken());
        this.creationDate = d2 = this.parseDate(date.toString());
        this.modificationDate = d2;
        this.parsed = true;
    }

    public long size() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return super.size();
    }
}

