/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs.test;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFile;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestRemoteFSBean
extends TestCase {
    private static boolean SECURE = true;
    private String dirname = "public";
    private String testDirName = "testdir";
    private String testFileName = "upload.test";

    private RemoteFSBean getBean() {
        RemoteFSBean bean = new RemoteFSBean();
        bean.setSecure(SECURE);
        return bean;
    }

    private String getPassword() {
        if (SECURE) {
            return "SftpPwd";
        }
        return "FtpPwd";
    }

    private String getServer() {
        if (SECURE) {
            return "sftpserver";
        }
        return "ftpserver";
    }

    private String getUser() {
        if (SECURE) {
            return "SftpUser";
        }
        return "FtpUser";
    }

    private void removeTestData() {
        System.out.println("Removing previous test-data ...");
        RemoteFSBean bean = this.getBean();
        try {
            bean.connect(this.getServer(), this.getUser(), this.getPassword());
            bean.setDirectory(this.dirname);
            try {
                bean.removeDirectory(this.testDirName);
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                bean.removeFile(this.testFileName);
            }
            catch (Exception e3) {
                // empty catch block
            }
            bean.disconnect();
        }
        catch (IOException e4) {
            Assert.fail((String)e4.getMessage());
        }
        catch (RemoteFSException e5) {
            Assert.fail((String)e5.getMessage());
        }
        System.out.println("... test-data removed");
    }

    public void testGetFiles() {
        RemoteFSBean bean = this.getBean();
        try {
            bean.connect(this.getServer(), this.getUser(), this.getPassword());
            RemoteFile[] files = bean.getFiles();
            Assert.assertNotNull((String)"Expected files", (Object)files);
            Assert.assertTrue((String)"Expected > 0 files", (files.length > 0 ? (char)'\u0001' : '\u0000') != '\u0000');
            bean.disconnect();
        }
        catch (IOException e2) {
            Assert.fail((String)e2.getMessage());
        }
        catch (RemoteFSException e3) {
            Assert.fail((String)e3.getMessage());
        }
    }

    public void testPutRemove() {
        this.removeTestData();
        System.out.println("Starting PutRemove test");
        RemoteFSBean bean = this.getBean();
        try {
            bean.connect(this.getServer(), this.getUser(), this.getPassword());
            Assert.assertTrue((String)"Not connected", (boolean)bean.isConnected());
            bean.setDirectory(this.dirname);
            String curDir = bean.getDirectory();
            Assert.assertTrue((String)"Not in public directory", (boolean)curDir.endsWith(this.dirname));
            bean.createDirectory(this.testDirName);
            File f2 = new File(this.testFileName);
            System.out.println(f2.getAbsolutePath());
            System.out.println(f2.getName());
            bean.putFile(f2);
            RemoteFile[] files = bean.getFiles();
            boolean fileFound = false;
            boolean dirFound = false;
            int i2 = 0;
            while (!(fileFound && dirFound || i2 >= files.length)) {
                RemoteFile rm = files[i2];
                if (rm.getName().equals(f2.getName())) {
                    if (rm.isFile()) {
                        fileFound = true;
                    } else {
                        Assert.fail((String)"Found file is not a file");
                    }
                } else if (rm.getName().equals(this.testDirName)) {
                    if (rm.isDirectory()) {
                        dirFound = true;
                    } else {
                        Assert.fail((String)"Found file is not a directory");
                    }
                }
                ++i2;
            }
            Assert.assertTrue((String)"Uploaded file not found", (boolean)fileFound);
            Assert.assertTrue((String)"Created directory not found", (boolean)dirFound);
            bean.toParentDirectory();
            String newDir = bean.getDirectory();
            Assert.assertTrue((String)"Directory not changed", (!newDir.equals(curDir) ? (char)'\u0001' : '\u0000') != '\u0000');
            bean.setDirectory("public");
            bean.removeFile(f2.getName());
            bean.removeDirectory(this.testDirName);
            files = bean.getFiles();
            fileFound = false;
            dirFound = false;
            i2 = 0;
            while (!(fileFound && dirFound || i2 >= files.length)) {
                RemoteFile rm = files[i2];
                if (rm.getName().equals(f2.getName())) {
                    if (rm.isFile()) {
                        fileFound = true;
                    } else {
                        Assert.fail((String)"Found file is not a file");
                    }
                } else if (rm.getName().equals(this.testDirName)) {
                    if (rm.isDirectory()) {
                        dirFound = true;
                    } else {
                        Assert.fail((String)"Found file is not a directory");
                    }
                }
                ++i2;
            }
            Assert.assertFalse((String)"Uploaded file still on remote server. Not removed.", (boolean)fileFound);
            Assert.assertFalse((String)"Created directory still on remote server. Not removed", (boolean)dirFound);
            bean.disconnect();
            Assert.assertFalse((String)"Still connected", (boolean)bean.isConnected());
        }
        catch (IOException e2) {
            Assert.fail((String)e2.getMessage());
        }
        catch (RemoteFSException e3) {
            Assert.fail((String)e3.getMessage());
        }
        System.out.println("PutRemove test finished");
    }

    public void testSetForceUTF8() {
        RemoteFSBean bean = this.getBean();
        try {
            bean.setForceUTF8(true);
            Assert.assertTrue((boolean)bean.isForceUTF8());
            bean.setForceUTF8(false);
            Assert.assertFalse((boolean)bean.isForceUTF8());
            bean.setForceUTF8(true);
            Assert.assertTrue((boolean)bean.isForceUTF8());
        }
        catch (RemoteFSException e2) {
            e2.printStackTrace();
            Assert.fail((String)e2.getMessage());
        }
    }

    public void testSetPassiveMode() {
        RemoteFSBean bean = this.getBean();
        try {
            bean.setPassiveMode(true);
            Assert.assertTrue((boolean)bean.isPassiveMode());
            bean.setPassiveMode(false);
            Assert.assertFalse((boolean)bean.isPassiveMode());
            bean.setPassiveMode(true);
            Assert.assertTrue((boolean)bean.isPassiveMode());
        }
        catch (RemoteFSException e2) {
            e2.printStackTrace();
            Assert.fail((String)e2.getMessage());
        }
    }

    public void testSetPort() {
        RemoteFSBean bean = this.getBean();
        try {
            bean.setPort(22);
            Assert.assertEquals((int)22, (int)bean.getPort());
            bean.setPort(11);
            Assert.assertEquals((int)11, (int)bean.getPort());
        }
        catch (RemoteFSException e2) {
            e2.printStackTrace();
            Assert.fail((String)e2.getMessage());
        }
    }

    public void testSetSecure() {
        RemoteFSBean bean = this.getBean();
        bean.setSecure(true);
        Assert.assertTrue((boolean)bean.isSecure());
        bean.setSecure(false);
        Assert.assertFalse((boolean)bean.isSecure());
        bean.setSecure(true);
        Assert.assertTrue((boolean)bean.isSecure());
    }

    public void testTestConnection() {
        RemoteFSBean bean = this.getBean();
        try {
            bean.testConnection(this.getServer(), this.getUser(), this.getPassword());
        }
        catch (Exception e2) {
            Assert.fail((String)e2.getMessage());
        }
    }
}

