/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.devices;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sbbi.upnp.devices.UPNPRootDevice;
import net.sbbi.upnp.services.UPNPService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UPNPDevice {
    private static final Log log = LogFactory.getLog(UPNPDevice.class);
    protected String deviceType;
    protected String friendlyName;
    protected String manufacturer;
    protected URL manufacturerURL;
    protected URL presentationURL;
    protected String modelDescription;
    protected String modelName;
    protected String modelNumber;
    protected String modelURL;
    protected String serialNumber;
    protected String UDN;
    protected String USN;
    protected long UPC;
    protected List deviceIcons;
    protected List services;
    protected List childDevices;
    protected UPNPDevice parent;

    public URL getManufacturerURL() {
        return this.manufacturerURL;
    }

    public URL getPresentationURL() {
        return this.presentationURL;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public String getModelURL() {
        return this.modelURL;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getUDN() {
        return this.UDN;
    }

    public String getUSN() {
        return this.USN;
    }

    public long getUPC() {
        return this.UPC;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public boolean isRootDevice() {
        return this instanceof UPNPRootDevice;
    }

    public List getDeviceIcons() {
        return this.deviceIcons;
    }

    public List getChildDevices() {
        if (this.childDevices == null) {
            return null;
        }
        ArrayList<UPNPDevice> rtrVal = new ArrayList<UPNPDevice>();
        Iterator itr = this.childDevices.iterator();
        while (itr.hasNext()) {
            UPNPDevice device = (UPNPDevice)itr.next();
            rtrVal.add(device);
            List found = device.getChildDevices();
            if (found == null) continue;
            rtrVal.addAll(found);
        }
        return rtrVal;
    }

    public List getTopLevelChildDevices() {
        if (this.childDevices == null) {
            return null;
        }
        ArrayList<UPNPDevice> rtrVal = new ArrayList<UPNPDevice>();
        Iterator itr = this.childDevices.iterator();
        while (itr.hasNext()) {
            UPNPDevice device = (UPNPDevice)itr.next();
            rtrVal.add(device);
        }
        return rtrVal;
    }

    public UPNPDevice getDirectParent() {
        return this.parent;
    }

    public UPNPDevice getChildDevice(String deviceURI) {
        if (log.isDebugEnabled()) {
            log.debug("searching for device URI:" + deviceURI);
        }
        if (this.getDeviceType().equals(deviceURI)) {
            return this;
        }
        if (this.childDevices == null) {
            return null;
        }
        Iterator itr = this.childDevices.iterator();
        while (itr.hasNext()) {
            UPNPDevice device = (UPNPDevice)itr.next();
            UPNPDevice found = device.getChildDevice(deviceURI);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public List getServices() {
        if (this.services == null) {
            return null;
        }
        ArrayList rtrVal = new ArrayList();
        rtrVal.addAll(this.services);
        return rtrVal;
    }

    public UPNPService getService(String serviceURI) {
        if (this.services == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("searching for service URI:" + serviceURI);
        }
        Iterator itr = this.services.iterator();
        while (itr.hasNext()) {
            UPNPService service = (UPNPService)itr.next();
            if (!service.getServiceType().equals(serviceURI)) continue;
            return service;
        }
        return null;
    }

    public UPNPService getServiceByID(String serviceID) {
        if (this.services == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("searching for service ID:" + serviceID);
        }
        Iterator itr = this.services.iterator();
        while (itr.hasNext()) {
            UPNPService service = (UPNPService)itr.next();
            if (!service.getServiceId().equals(serviceID)) continue;
            return service;
        }
        return null;
    }

    public List getServices(String serviceURI) {
        if (this.services == null) {
            return null;
        }
        ArrayList<UPNPService> rtrVal = new ArrayList<UPNPService>();
        if (log.isDebugEnabled()) {
            log.debug("searching for services URI:" + serviceURI);
        }
        Iterator itr = this.services.iterator();
        while (itr.hasNext()) {
            UPNPService service = (UPNPService)itr.next();
            if (!service.getServiceType().equals(serviceURI)) continue;
            rtrVal.add(service);
        }
        if (rtrVal.size() == 0) {
            return null;
        }
        return rtrVal;
    }

    public String toString() {
        return this.getDeviceType();
    }
}

