/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import net.sbbi.upnp.Discovery;
import net.sbbi.upnp.DiscoveryAdvertisement;
import net.sbbi.upnp.DiscoveryEventHandler;
import net.sbbi.upnp.devices.UPNPDevice;
import net.sbbi.upnp.devices.UPNPRootDevice;
import net.sbbi.upnp.jmx.UPNPDiscoveryMBean;
import net.sbbi.upnp.jmx.UPNPDiscoveryNotification;
import net.sbbi.upnp.jmx.UPNPServiceMBean;
import net.sbbi.upnp.services.UPNPService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UPNPDiscovery
implements DiscoveryEventHandler,
UPNPDiscoveryMBean,
NotificationBroadcaster {
    private static final Log log = LogFactory.getLog(UPNPDiscovery.class);
    private MBeanServer server;
    private NotificationBroadcasterSupport notifier;
    private MBeanNotificationInfo[] notifInfo;
    private Map registeredBeansPerUDN;
    private Set searchTargets;
    private int discoveryTimeout;
    private boolean notifySSDPEvents;
    private boolean registerChildDevices;
    private long ssdpAliveSequenceNumber = 0L;
    private long ssdpByeByeSequenceNumber = 0L;

    public UPNPDiscovery(int discoveryTimeout, boolean notifySSDPEvents, boolean registerChildDevices) {
        this.registerChildDevices = registerChildDevices;
        this.notifySSDPEvents = notifySSDPEvents;
        this.discoveryTimeout = discoveryTimeout;
        if (this.discoveryTimeout == 0) {
            this.discoveryTimeout = 1500;
        }
        this.notifier = new NotificationBroadcasterSupport();
        this.registeredBeansPerUDN = new HashMap();
        String[] types = new String[]{SSDP_ALIVE_NOTIFICATION, SSDP_BYEBYE_NOTIFICATION};
        this.notifInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, Notification.class.getName(), "SSDP UPNP events notifications")};
        this.searchTargets = new HashSet();
        this.searchTargets.add("upnp:rootdevice");
    }

    public UPNPDiscovery(String searchTargets, int discoveryTimeout, boolean notifySSDPEvents, boolean registerChildDevices) {
        this(discoveryTimeout, notifySSDPEvents, registerChildDevices);
        String[] targets = searchTargets.split(",");
        this.searchTargets.clear();
        for (int i2 = 0; i2 < targets.length; ++i2) {
            this.searchTargets.add(targets[i2]);
        }
    }

    public UPNPDiscovery(String[] searchTargets, int discoveryTimeout, boolean notifySSDPEvents, boolean registerChildDevices) {
        this(discoveryTimeout, notifySSDPEvents, registerChildDevices);
        this.searchTargets.clear();
        for (int i2 = 0; i2 < searchTargets.length; ++i2) {
            this.searchTargets.add(searchTargets[i2]);
        }
    }

    public ObjectName[] getRegisteredUPNPServiceMBeans(String deviceUDN) throws MalformedObjectNameException {
        Set registeredBeans = (Set)this.registeredBeansPerUDN.get(deviceUDN);
        ObjectName[] rtrVal = null;
        if (registeredBeans != null && registeredBeans.size() > 0) {
            HashSet copy = new HashSet(registeredBeans);
            rtrVal = new ObjectName[copy.size()];
            int z2 = 0;
            Iterator i2 = copy.iterator();
            while (i2.hasNext()) {
                UPNPServiceMBean srv = (UPNPServiceMBean)i2.next();
                rtrVal[z2++] = srv.getObjectName();
            }
        }
        return rtrVal;
    }

    public String[] getRegisteredUPNPServiceMBeansUDNs() {
        if (this.registeredBeansPerUDN.size() == 0) {
            return null;
        }
        HashMap copy = new HashMap(this.registeredBeansPerUDN);
        String[] rtrVal = new String[copy.size()];
        int z2 = 0;
        Iterator i2 = copy.keySet().iterator();
        while (i2.hasNext()) {
            rtrVal[z2++] = (String)i2.next();
        }
        return rtrVal;
    }

    public Set getSearchTargets() {
        return Collections.unmodifiableSet(this.searchTargets);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object callback) throws IllegalArgumentException {
        this.notifier.addNotificationListener(listener, filter, callback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notifySSDPEvents) {
            return this.notifInfo;
        }
        return null;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener);
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeregister() throws Exception {
        if (this.notifySSDPEvents) {
            Iterator i2 = this.searchTargets.iterator();
            while (i2.hasNext()) {
                String st = (String)i2.next();
                DiscoveryAdvertisement.getInstance().unRegisterEvent(0, st, this);
                DiscoveryAdvertisement.getInstance().unRegisterEvent(1, st, this);
            }
        }
        Map map = this.registeredBeansPerUDN;
        synchronized (map) {
            Iterator i3 = this.registeredBeansPerUDN.values().iterator();
            while (i3.hasNext()) {
                Set registeredMBeans = (Set)i3.next();
                Iterator z2 = registeredMBeans.iterator();
                while (z2.hasNext()) {
                    UPNPServiceMBean bean = (UPNPServiceMBean)z2.next();
                    this.server.unregisterMBean(bean.getObjectName());
                }
            }
        }
        this.registeredBeansPerUDN.clear();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectname) throws Exception {
        this.server = server;
        this.discoverDevices(this.discoveryTimeout);
        if (this.notifySSDPEvents) {
            Iterator i2 = this.searchTargets.iterator();
            while (i2.hasNext()) {
                String st = (String)i2.next();
                DiscoveryAdvertisement.getInstance().registerEvent(0, st, this);
                DiscoveryAdvertisement.getInstance().registerEvent(1, st, this);
            }
        }
        return objectname;
    }

    public void eventSSDPAlive(String usn, String udn, String nt, String maxAge, URL location) {
        if (this.registeredBeansPerUDN.get(udn) == null && (this.searchTargets.contains("upnp:rootdevice") || this.searchTargets.contains(nt))) {
            try {
                UPNPRootDevice newDevice = new UPNPRootDevice(location, maxAge, null, usn, udn);
                log.info("Registering new device " + newDevice.getModelName() + " at " + location);
                this.register(newDevice, nt, null, null);
                UPNPDiscoveryNotification notif = new UPNPDiscoveryNotification(UPNPDiscoveryMBean.SSDP_ALIVE_NOTIFICATION, (Object)this, this.ssdpAliveSequenceNumber++, System.currentTimeMillis());
                notif.setLocation(location);
                notif.setNt(nt);
                notif.setUdn(udn);
                notif.setUsn(usn);
                notif.setUPNPServiceMBeans(this.getRegisteredUPNPServiceMBeans(udn));
                this.notifier.sendNotification(notif);
            }
            catch (Exception ex) {
                log.error("Error during new device " + location + " registration", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventSSDPByeBye(String usn, String udn, String nt) {
        Map map = this.registeredBeansPerUDN;
        synchronized (map) {
            Set registeredBeans = (Set)this.registeredBeansPerUDN.get(udn);
            if (registeredBeans != null) {
                UPNPDiscoveryNotification notif = new UPNPDiscoveryNotification(UPNPDiscoveryMBean.SSDP_BYEBYE_NOTIFICATION, (Object)this, this.ssdpByeByeSequenceNumber++, System.currentTimeMillis());
                notif.setNt(nt);
                notif.setUdn(udn);
                notif.setUsn(usn);
                try {
                    notif.setUPNPServiceMBeans(this.getRegisteredUPNPServiceMBeans(udn));
                }
                catch (MalformedObjectNameException ex) {
                    log.error("Error during UPNPServiceMBean unregistration notification", ex);
                }
                log.info("Device " + usn + " shutdown");
                Iterator i2 = registeredBeans.iterator();
                while (i2.hasNext()) {
                    UPNPServiceMBean bean = (UPNPServiceMBean)i2.next();
                    try {
                        this.server.unregisterMBean(bean.getObjectName());
                    }
                    catch (Exception ex) {
                        log.error("Error during UPNPServiceMBean unregistration", ex);
                    }
                }
                this.registeredBeansPerUDN.remove(udn);
                this.notifier.sendNotification(notif);
            }
        }
    }

    public void discoverDevices(int timeout) throws Exception {
        UPNPRootDevice[] dev = Discovery.discover(timeout, "upnp:rootdevice");
        if (dev != null) {
            for (int i2 = 0; i2 < dev.length; ++i2) {
                Iterator j2 = this.searchTargets.iterator();
                while (j2.hasNext()) {
                    String st = (String)j2.next();
                    this.register(dev[i2], st, null, null);
                }
            }
        } else {
            log.info("No devices found on the network");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(UPNPDevice device, String searchTarget, Set registeredMBeansContainer, String deviceUDN) throws Exception {
        List childrens = device.getTopLevelChildDevices();
        if (searchTarget.equals("upnp:rootdevice") || device.getDeviceType().equals(searchTarget)) {
            Map map = this.registeredBeansPerUDN;
            synchronized (map) {
                List services;
                if (deviceUDN == null) {
                    deviceUDN = device.getUDN();
                }
                log.info("Registering UPNP device " + device.getDeviceType() + " " + device.getUDN() + " services");
                if (registeredMBeansContainer == null) {
                    registeredMBeansContainer = new HashSet();
                    this.registeredBeansPerUDN.put(deviceUDN, registeredMBeansContainer);
                }
                if ((services = device.getServices()) != null) {
                    this.registerServices(device, this.server, services, registeredMBeansContainer);
                }
                if (childrens != null) {
                    if (this.registerChildDevices) {
                        Iterator itr = childrens.iterator();
                        while (itr.hasNext()) {
                            UPNPDevice childDevice = (UPNPDevice)itr.next();
                            this.register(childDevice, "upnp:rootdevice", registeredMBeansContainer, deviceUDN);
                        }
                    }
                    childrens = null;
                }
            }
        }
        if (childrens != null) {
            Iterator itr = childrens.iterator();
            while (itr.hasNext()) {
                UPNPDevice childDevice = (UPNPDevice)itr.next();
                this.register(childDevice, searchTarget, null, deviceUDN);
            }
        }
    }

    private void registerServices(UPNPDevice device, MBeanServer server, List services, Set beansContainer) throws Exception {
        Iterator i2 = services.iterator();
        while (i2.hasNext()) {
            UPNPService srv = (UPNPService)i2.next();
            UPNPServiceMBean mBean = new UPNPServiceMBean(device, srv, null, null);
            log.info("Registering service " + srv.getServiceId());
            server.registerMBean(mBean, mBean.getObjectName());
            beansContainer.add(mBean);
        }
    }
}

