/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.remote;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerCloneException;
import java.rmi.server.ServerRef;
import net.sbbi.upnp.Discovery;
import net.sbbi.upnp.devices.UPNPDevice;
import net.sbbi.upnp.devices.UPNPRootDevice;
import net.sbbi.upnp.messages.ActionMessage;
import net.sbbi.upnp.messages.UPNPMessageFactory;
import net.sbbi.upnp.services.UPNPService;

public class UnicastRemoteObject
extends RemoteServer {
    private static final long serialVersionUID = 4974527148936298034L;
    private static Class[] portParamTypes = new Class[]{Integer.TYPE};
    private static Class[] portFactoryParamTypes = new Class[]{Integer.TYPE, RMIClientSocketFactory.class, RMIServerSocketFactory.class};
    private static final Object DISCOVERY_PROCESS = new Object();
    private static final Object ANONYMOUS_PORT_LOOKUP = new Object();
    private UPNPDevice wanConnDevice = null;
    private boolean discoveryProcessCall = false;
    private boolean portOpened = false;
    private int port = 0;
    private RMIClientSocketFactory csf = null;
    private RMIServerSocketFactory ssf = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UnicastRemoteObject() throws RemoteException {
        Object object = ANONYMOUS_PORT_LOOKUP;
        synchronized (object) {
            try {
                ServerSocket srv = new ServerSocket(0);
                this.port = srv.getLocalPort();
                srv.close();
            }
            catch (Exception ex) {
                throw new RemoteException("Error occured during anonymous port assignation", ex);
            }
        }
        this.openPort();
        UnicastRemoteObject.exportObject(this, this.port);
    }

    protected UnicastRemoteObject(int port) throws RemoteException {
        this.port = port;
        this.openPort();
        UnicastRemoteObject.exportObject(this, port);
    }

    protected UnicastRemoteObject(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
        this.openPort();
        UnicastRemoteObject.exportObject((Remote)this, port, csf, ssf);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.reexport();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            UnicastRemoteObject cloned = (UnicastRemoteObject)super.clone();
            cloned.reexport();
            return cloned;
        }
        catch (RemoteException e2) {
            throw new ServerCloneException("Clone failed", e2);
        }
    }

    private void reexport() throws RemoteException {
        this.closePort();
        if (this.csf == null && this.ssf == null) {
            UnicastRemoteObject.exportObject(this, this.port);
        } else {
            UnicastRemoteObject.exportObject((Remote)this, this.port, this.csf, this.ssf);
        }
        this.openPort();
    }

    public static RemoteStub exportObject(Remote obj) throws RemoteException {
        return (RemoteStub)UnicastRemoteObject.exportObject(obj, 0);
    }

    public static Remote exportObject(Remote obj, int port) throws RemoteException {
        Object[] args = new Object[]{new Integer(port)};
        return UnicastRemoteObject.exportObject(obj, "UnicastServerRef", portParamTypes, args);
    }

    public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        Object[] args = new Object[]{new Integer(port), csf, ssf};
        return UnicastRemoteObject.exportObject(obj, "UnicastServerRef2", portFactoryParamTypes, args);
    }

    private static Remote exportObject(Remote obj, String refType, Class[] params, Object[] args) throws RemoteException {
        ServerRef serverRef;
        Class<?> refClass;
        String refClassName = "sun.rmi.server." + refType;
        try {
            refClass = Class.forName(refClassName);
        }
        catch (ClassNotFoundException e2) {
            throw new ExportException("No class found for server ref type: " + refType);
        }
        if (!ServerRef.class.isAssignableFrom(refClass)) {
            throw new ExportException("Server ref class not instance of " + ServerRef.class.getName() + ": " + refClass.getName());
        }
        try {
            Constructor<?> cons = refClass.getConstructor(params);
            serverRef = (ServerRef)cons.newInstance(args);
            if (obj instanceof UnicastRemoteObject) {
                ((UnicastRemoteObject)obj).ref = serverRef;
            }
        }
        catch (Exception e3) {
            throw new ExportException("Exception creating instance of server ref class: " + refClass.getName(), e3);
        }
        return serverRef.exportObject(obj, null);
    }

    private void openPort() throws RemoteException {
        block7: {
            this.discoverDevice();
            if (this.wanConnDevice != null && !this.portOpened) {
                UPNPService wanIPSrv = this.wanConnDevice.getService("urn:schemas-upnp-org:service:WANIPConnection:1");
                String failStr = System.getProperty("net.sbbi.upnp.remote.failWhenNoDeviceFound");
                boolean fail = false;
                if (failStr != null && failStr.equalsIgnoreCase("true")) {
                    fail = true;
                }
                if (wanIPSrv == null && fail) {
                    throw new RemoteException("Device does not implement the urn:schemas-upnp-org:service:WANIPConnection:1 service");
                }
                if (wanIPSrv == null && !fail) {
                    return;
                }
                failStr = System.getProperty("net.sbbi.upnp.remote.failWhenDeviceCommEx");
                fail = false;
                if (failStr != null && failStr.equalsIgnoreCase("true")) {
                    fail = true;
                }
                UPNPMessageFactory msgFactory = UPNPMessageFactory.getNewInstance(wanIPSrv);
                ActionMessage msg = msgFactory.getMessage("AddPortMapping");
                try {
                    String localIP = InetAddress.getLocalHost().getHostAddress();
                    msg.setInputParameter("NewRemoteHost", "").setInputParameter("NewExternalPort", this.port).setInputParameter("NewProtocol", "TCP").setInputParameter("NewInternalPort", this.port).setInputParameter("NewInternalClient", localIP).setInputParameter("NewEnabled", "1").setInputParameter("NewPortMappingDescription", "Remote Object " + this.getClass().getName() + " " + this.hashCode()).setInputParameter("NewLeaseDuration", "0");
                    msg.service();
                    this.portOpened = true;
                    UnicastObjectShutdownHook hook = new UnicastObjectShutdownHook(this);
                    Runtime.getRuntime().addShutdownHook(hook);
                }
                catch (Exception ex) {
                    if (!fail) break block7;
                    throw new RemoteException("Error occured during port mapping", ex);
                }
            }
        }
    }

    public void closePort() {
        UPNPService wanIPSrv;
        if (this.wanConnDevice != null && this.portOpened && (wanIPSrv = this.wanConnDevice.getService("urn:schemas-upnp-org:service:WANIPConnection:1")) != null) {
            UPNPMessageFactory msgFactory = UPNPMessageFactory.getNewInstance(wanIPSrv);
            ActionMessage msg = msgFactory.getMessage("DeletePortMapping");
            try {
                msg.setInputParameter("NewRemoteHost", "").setInputParameter("NewExternalPort", this.port).setInputParameter("NewProtocol", "TCP");
                msg.service();
                this.portOpened = false;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void discoverDevice() throws RemoteException {
        Object object = DISCOVERY_PROCESS;
        synchronized (object) {
            if (!this.discoveryProcessCall) {
                this.discoveryProcessCall = true;
                UPNPRootDevice rootIGDDevice = null;
                String failStr = System.getProperty("net.sbbi.upnp.remote.failWhenNoDeviceFound");
                boolean fail = false;
                if (failStr != null && failStr.equalsIgnoreCase("true")) {
                    fail = true;
                }
                UPNPRootDevice[] devices = null;
                try {
                    String timeout = System.getProperty("net.sbbi.upnp.remote.discoveryTimeout");
                    devices = timeout != null ? Discovery.discover(Integer.parseInt(timeout), "urn:schemas-upnp-org:device:InternetGatewayDevice:1") : Discovery.discover("urn:schemas-upnp-org:device:InternetGatewayDevice:1");
                }
                catch (IOException ex) {
                    throw new RemoteException("IOException occured during devices discovery", ex);
                }
                if (devices == null && fail) {
                    throw new IllegalStateException("No UPNP IGD (urn:schemas-upnp-org:device:InternetGatewayDevice:1) available, unable to create object");
                }
                if (devices != null && devices.length > 1) {
                    String deviceUDN = System.getProperty("net.sbbi.upnp.remote.deviceUDN");
                    if (deviceUDN == null) {
                        String UDNs = "";
                        for (int i2 = 0; i2 < devices.length; ++i2) {
                            UPNPRootDevice dv2 = devices[i2];
                            UDNs = UDNs + dv2.getUDN();
                            if (i2 >= devices.length) continue;
                            UDNs = UDNs + ", ";
                        }
                        throw new RemoteException("Found multiple IDG UPNP devices UDN's :" + UDNs + ", " + "please set the net.sbbi.upnp.remote.deviceUDN system " + "property with one of the following identifier to define " + "which UPNP device need to be used with remote objects");
                    }
                    StringBuffer foundUDN = new StringBuffer();
                    for (int i3 = 0; i3 < devices.length; ++i3) {
                        UPNPRootDevice dv3 = devices[i3];
                        if (dv3.getUDN().equals(deviceUDN)) {
                            rootIGDDevice = dv3;
                            break;
                        }
                        foundUDN.append(dv3.getUDN());
                        if (i3 >= devices.length) continue;
                        foundUDN.append(", ");
                    }
                    if (rootIGDDevice == null) {
                        throw new RemoteException("No UPNP device matching UDN :" + deviceUDN + ", found UDN(s) are :" + foundUDN);
                    }
                } else if (devices != null) {
                    rootIGDDevice = devices[0];
                }
                if (rootIGDDevice != null) {
                    this.wanConnDevice = rootIGDDevice.getChildDevice("urn:schemas-upnp-org:device:WANConnectionDevice:1");
                    if (this.wanConnDevice == null && fail) {
                        throw new RemoteException("Your UPNP device does not implements urn:schemas-upnp-org:device:WANConnectionDevice:1 required specs for NAT transversal");
                    }
                }
            }
        }
    }

    private class UnicastObjectShutdownHook
    extends Thread {
        private UnicastRemoteObject object;

        private UnicastObjectShutdownHook(UnicastRemoteObject object) {
            this.object = object;
        }

        public void run() {
            this.object.closePort();
        }
    }
}

