/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import java.io.StringReader;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.parser.ParseException;
import org.apache.commons.jxpath.ri.parser.TokenMgrError;
import org.apache.commons.jxpath.ri.parser.XPathParser;

public class Parser {
    private static XPathParser parser = new XPathParser(new StringReader(""));

    public static Object parseExpression(String expression, Compiler compiler) {
        XPathParser xPathParser = parser;
        synchronized (xPathParser) {
            parser.setCompiler(compiler);
            Object expr = null;
            try {
                parser.ReInit(new StringReader(expression));
                expr = parser.parseExpression();
            }
            catch (TokenMgrError e2) {
                throw new JXPathException("Invalid XPath: '" + Parser.addEscapes(expression) + "'. Invalid symbol '" + Parser.addEscapes(String.valueOf(e2.getCharacter())) + "' " + Parser.describePosition(expression, e2.getPosition()));
            }
            catch (ParseException e3) {
                throw new JXPathException("Invalid XPath: '" + Parser.addEscapes(expression) + "'. Syntax error " + Parser.describePosition(expression, e3.currentToken.beginColumn));
            }
            Object object = expr;
            return object;
        }
    }

    private static String describePosition(String expression, int position) {
        if (position <= 0) {
            return "at the beginning of the expression";
        }
        if (position >= expression.length()) {
            return "- expression incomplete";
        }
        return "after: '" + Parser.addEscapes(expression.substring(0, position)) + "'";
    }

    private static String addEscapes(String string) {
        return TokenMgrError.addEscapes(string);
    }
}

