/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.InfoSetUtil;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.axes.SelfContext;
import org.apache.commons.jxpath.ri.compiler.CoreOperation;
import org.apache.commons.jxpath.ri.compiler.Expression;

public abstract class CoreOperationCompare
extends CoreOperation {
    public CoreOperationCompare(Expression arg1, Expression arg2) {
        super(new Expression[]{arg1, arg2});
    }

    protected boolean equal(EvalContext context, Expression left, Expression right) {
        Iterator l2 = left.compute(context);
        Iterator r2 = right.compute(context);
        if (l2 instanceof InitialContext || l2 instanceof SelfContext) {
            l2 = ((EvalContext)l2).getSingleNodePointer();
        }
        if (r2 instanceof InitialContext || r2 instanceof SelfContext) {
            r2 = ((EvalContext)r2).getSingleNodePointer();
        }
        if (l2 instanceof Collection) {
            l2 = ((Collection)((Object)l2)).iterator();
        }
        if (r2 instanceof Collection) {
            r2 = ((Collection)((Object)r2)).iterator();
        }
        if (l2 instanceof Iterator && !(r2 instanceof Iterator)) {
            return this.contains(l2, r2);
        }
        if (!(l2 instanceof Iterator) && r2 instanceof Iterator) {
            return this.contains(r2, l2);
        }
        if (l2 instanceof Iterator && r2 instanceof Iterator) {
            return this.findMatch(l2, r2);
        }
        return this.equal(l2, r2);
    }

    protected boolean contains(Iterator it, Object value) {
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.equal(element, value)) continue;
            return true;
        }
        return false;
    }

    protected boolean findMatch(Iterator lit, Iterator rit) {
        HashSet left = new HashSet();
        while (lit.hasNext()) {
            left.add(lit.next());
        }
        while (rit.hasNext()) {
            if (!this.contains(left.iterator(), rit.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean equal(Object l2, Object r2) {
        if (l2 instanceof Pointer && r2 instanceof Pointer && l2.equals(r2)) {
            return true;
        }
        if (l2 instanceof Pointer) {
            l2 = ((Pointer)l2).getValue();
        }
        if (r2 instanceof Pointer) {
            r2 = ((Pointer)r2).getValue();
        }
        if (l2 == r2) {
            return true;
        }
        if (l2 instanceof Boolean || r2 instanceof Boolean) {
            return InfoSetUtil.booleanValue(l2) == InfoSetUtil.booleanValue(r2);
        }
        if (l2 instanceof Number || r2 instanceof Number) {
            return InfoSetUtil.doubleValue(l2) == InfoSetUtil.doubleValue(r2);
        }
        if (l2 instanceof String || r2 instanceof String) {
            return InfoSetUtil.stringValue(l2).equals(InfoSetUtil.stringValue(r2));
        }
        if (l2 == null) {
            return r2 == null;
        }
        return l2.equals(r2);
    }
}

