/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mortbay.html.Frame;
import org.mortbay.html.Page;

public class FrameSet
extends Page {
    Frame[][] frames = null;
    String colSpec = null;
    String rowSpec = null;
    int cols;
    int rows;
    String border = "";
    Vector frameNames = null;
    Hashtable frameMap = null;

    public FrameSet(String title, String colSpec, String rowSpec) {
        super(title);
        this.colSpec = colSpec;
        this.rowSpec = rowSpec;
        this.cols = 1;
        this.rows = 1;
        int i2 = -1;
        while (colSpec != null && (i2 = colSpec.indexOf(",", i2 + 1)) >= 0) {
            ++this.cols;
        }
        i2 = -1;
        while (rowSpec != null && (i2 = rowSpec.indexOf(",", i2 + 1)) >= 0) {
            ++this.rows;
        }
        this.frames = new Frame[this.cols][this.rows];
        for (int c2 = 0; c2 < this.cols; ++c2) {
            for (int r2 = 0; r2 < this.rows; ++r2) {
                this.frames[c2][r2] = new Frame();
            }
        }
    }

    public Frame frame(int col, int row) {
        return this.frames[col][row];
    }

    public FrameSet border(boolean threeD, int width, String color) {
        this.border = " frameborder=\"" + (threeD ? "yes" : "no") + "\"";
        if (width >= 0) {
            this.border = this.border + " border=\"" + width + "\"";
        }
        if (color != null) {
            this.border = this.border + " bordercolor=\"" + color + "\"";
        }
        return this;
    }

    public Enumeration namedFrames() {
        if (this.frameNames == null) {
            return new Vector().elements();
        }
        return this.frameNames.elements();
    }

    public Frame frame(String name) {
        if (this.frameMap == null) {
            return null;
        }
        return (Frame)this.frameMap.get(name);
    }

    public Frame nameFrame(String name, int col, int row) {
        Frame frame;
        if (this.frameMap == null) {
            this.frameMap = new Hashtable(10);
            this.frameNames = new Vector(10);
        }
        if ((frame = this.frames[col][row]) == null) {
            Frame frame2 = new Frame();
            this.frames[col][row] = frame2;
            frame = frame2;
        }
        if (this.frameMap.get(name) == null) {
            this.frameNames.addElement(name);
        }
        this.frameMap.put(name, frame);
        frame.name(name);
        return frame;
    }

    public void write(Writer out) throws IOException {
        this.writeHtmlHead(out);
        out.write("<frameset " + this.border);
        if (this.colSpec != null) {
            out.write(" cols=\"" + this.colSpec + "\"");
        }
        if (this.rowSpec != null) {
            out.write(" rows=\"" + this.rowSpec + "\"");
        }
        out.write(">");
        for (int r2 = 0; r2 < this.rows; ++r2) {
            for (int c2 = 0; c2 < this.cols; ++c2) {
                this.frames[c2][r2].write(out);
            }
        }
        out.write("<noframes>");
        this.writeElements(out);
        out.write("</noframes>");
        out.write("</frameset>");
        out.write("</html>");
    }
}

