/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.OutputStream;
import org.mortbay.http.EOFException;
import org.mortbay.http.HttpMessage;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.ByteBufferOutputStream;
import org.mortbay.util.OutputObserver;

public class BufferedOutputStream
extends ByteBufferOutputStream
implements HttpMessage.HeaderWriter {
    protected OutputStream _out;
    protected ByteArrayISO8859Writer _httpMessageWriter;
    private OutputObserver _commitObserver;
    private boolean _commited;
    private int _preReserve;
    private boolean _bypassBuffer;

    public BufferedOutputStream(OutputStream out, int capacity, int headerReserve, int preReserve, int postReserve) {
        super(capacity, headerReserve, postReserve);
        this._out = out;
        this._preReserve = preReserve;
        this._httpMessageWriter = new ByteArrayISO8859Writer(headerReserve);
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public OutputObserver getCommitObserver() {
        return this._commitObserver;
    }

    public void setCommitObserver(OutputObserver commitObserver) {
        this._commitObserver = commitObserver;
    }

    public boolean isCommitted() {
        return this._commited;
    }

    public boolean getBypassBuffer() {
        return this._bypassBuffer;
    }

    public void setBypassBuffer(boolean bypassBuffer) {
        this._bypassBuffer = bypassBuffer;
    }

    public void writeHeader(HttpMessage httpMessage) throws IOException {
        httpMessage.writeHeader(this._httpMessageWriter);
    }

    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public void write(byte[] b2, int offset, int length) throws IOException {
        int o2 = offset;
        int l2 = length;
        while (l2 > 0) {
            int c2 = this.capacity();
            if (this._bypassBuffer && this.isCommitted() && this.size() == 0 && l2 > c2) {
                this.bypassWrite(b2, o2, l2);
                break;
            }
            if (l2 < c2 || !this.isFixed()) {
                super.write(b2, o2, l2);
                break;
            }
            super.write(b2, o2, c2);
            this.flush();
            l2 -= c2;
            o2 += c2;
        }
    }

    protected void bypassWrite(byte[] b2, int offset, int length) throws IOException {
        try {
            this._out.write(b2, offset, length);
            this._out.flush();
        }
        catch (IOException e2) {
            throw new EOFException(e2);
        }
    }

    public void flush() throws IOException {
        try {
            if (!this._commited) {
                this._commited = true;
                if (this._commitObserver != null) {
                    this._commitObserver.outputNotify(this, 2, null);
                }
            }
            this.wrapBuffer();
            if (this._httpMessageWriter.size() > 0) {
                this.prewrite(this._httpMessageWriter.getBuf(), 0, this._httpMessageWriter.size());
                this._httpMessageWriter.resetWriter();
            }
            if (this.size() > 0) {
                this.writeTo(this._out);
            }
        }
        catch (IOException e2) {
            throw new EOFException(e2);
        }
        finally {
            this.reset(this._preReserve);
        }
    }

    protected void wrapBuffer() throws IOException {
    }

    public void close() throws IOException {
        this.flush();
        this._out.close();
    }

    public void resetStream() {
        super.reset(this._httpMessageWriter.capacity());
        this._commited = false;
    }

    public void destroy() {
        super.destroy();
        if (this._httpMessageWriter != null) {
            this._httpMessageWriter.destroy();
        }
        this._httpMessageWriter = null;
        this._out = null;
    }
}

