/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.Resource;

public class ContextLoader
extends URLClassLoader {
    private static Log log = LogFactory.getLog(ContextLoader.class);
    private boolean _java2compliant;
    private ClassLoader _parent;
    private PermissionCollection _permissions;
    private String _urlClassPath;
    private HttpContext _context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLoader(HttpContext context, String classPath, ClassLoader parent, PermissionCollection permisions) throws MalformedURLException, IOException {
        block13: {
            block12: {
                super(new URL[0], parent);
                this._java2compliant = false;
                this._context = context;
                this._permissions = permisions;
                this._parent = parent;
                if (this._parent == null) {
                    this._parent = ContextLoader.getSystemClassLoader();
                }
                if (classPath != null) break block12;
                this._urlClassPath = "";
                break block13;
            }
            StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
            while (tokenizer.hasMoreTokens()) {
                URL url;
                Resource resource;
                block14: {
                    File file;
                    resource = Resource.newResource(tokenizer.nextToken());
                    if (log.isDebugEnabled()) {
                        log.debug("Path resource=" + resource);
                    }
                    if ((file = resource.getFile()) != null) {
                        url = resource.getURL();
                        this.addURL(url);
                        this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
                        continue;
                    }
                    if (resource.isDirectory() || file != null) break block14;
                    InputStream in = resource.getInputStream();
                    File lib = new File(context.getTempDirectory(), "lib");
                    if (!lib.exists()) {
                        lib.mkdir();
                        lib.deleteOnExit();
                    }
                    File jar = File.createTempFile("Jetty-", ".jar", lib);
                    jar.deleteOnExit();
                    if (log.isDebugEnabled()) {
                        log.debug("Extract " + resource + " to " + jar);
                    }
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(jar);
                        IO.copy(in, out);
                    }
                    catch (Throwable throwable) {
                        IO.close(out);
                        throw throwable;
                    }
                    IO.close(out);
                    URL url2 = jar.toURL();
                    this.addURL(url2);
                    this._urlClassPath = this._urlClassPath == null ? url2.toString() : this._urlClassPath + "," + url2.toString();
                    continue;
                }
                url = resource.getURL();
                this.addURL(url);
                this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
            }
        }
        if (log.isDebugEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("ClassPath=" + this._urlClassPath);
            }
            if (log.isDebugEnabled()) {
                log.debug("Permissions=" + this._permissions);
            }
            if (log.isDebugEnabled()) {
                log.debug("URL=" + Arrays.asList(this.getURLs()));
            }
        }
    }

    public void setJava2Compliant(boolean compliant) {
        this._java2compliant = compliant;
    }

    public boolean isJava2Compliant() {
        return this._java2compliant;
    }

    public String toString() {
        return "ContextLoader@" + this.hashCode() + "(" + this._urlClassPath + ")\n  --parent--> " + this._parent.toString();
    }

    public PermissionCollection getPermissions(CodeSource cs2) {
        PermissionCollection pc;
        PermissionCollection permissionCollection = pc = this._permissions == null ? super.getPermissions(cs2) : this._permissions;
        if (log.isDebugEnabled()) {
            log.debug("loader.getPermissions(" + cs2 + ")=" + pc);
        }
        return pc;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c2 = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        if (c2 == null && (this._java2compliant || this.isSystemPath(name)) && !this.isServerPath(name) && this._parent != null) {
            if (log.isTraceEnabled()) {
                log.trace("try loadClass " + name + " from " + this._parent);
            }
            tried_parent = true;
            try {
                c2 = this._parent.loadClass(name);
                if (log.isTraceEnabled()) {
                    log.trace("p0 loaded " + c2);
                }
            }
            catch (ClassNotFoundException e2) {
                ex = e2;
            }
        }
        if (c2 == null) {
            if (log.isTraceEnabled()) {
                log.trace("try findClass " + name + " from " + this._urlClassPath);
            }
            try {
                c2 = this.findClass(name);
                if (log.isTraceEnabled()) {
                    log.trace("cx loaded " + c2);
                }
            }
            catch (ClassNotFoundException e3) {
                ex = e3;
            }
        }
        if (c2 == null && !tried_parent && !this.isServerPath(name) && this._parent != null) {
            if (log.isTraceEnabled()) {
                log.trace("try loadClass " + name + " from " + this._parent);
            }
            c2 = this._parent.loadClass(name);
            if (log.isTraceEnabled()) {
                log.trace("p1 loaded " + c2);
            }
        }
        if (c2 == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c2);
        }
        return c2;
    }

    public URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        if (this._parent != null && (this._java2compliant || this.isSystemPath(name))) {
            if (log.isTraceEnabled()) {
                log.trace("try getResource " + name + " from " + this._parent);
            }
            tried_parent = true;
            url = this._parent.getResource(name);
        }
        if (url == null) {
            if (log.isTraceEnabled()) {
                log.trace("try findResource " + name + " from " + this._urlClassPath);
            }
            if ((url = this.findResource(name)) == null && name.startsWith("/")) {
                if (log.isDebugEnabled()) {
                    log.debug("HACK leading / off " + name);
                }
                url = this.findResource(name.substring(1));
            }
        }
        if (this._parent != null && url == null && !tried_parent) {
            if (log.isTraceEnabled()) {
                log.trace("try getResource " + name + " from " + this._parent);
            }
            url = this._parent.getResource(name);
        }
        if (url != null && log.isTraceEnabled()) {
            log.trace("found " + url);
        }
        return url;
    }

    public boolean isServerPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] server_classes = this._context.getServerClasses();
        if (server_classes != null) {
            for (int i2 = 0; i2 < server_classes.length; ++i2) {
                boolean result = true;
                String c2 = server_classes[i2];
                if (c2.startsWith("-")) {
                    c2 = c2.substring(1);
                    result = false;
                }
                if (!(c2.endsWith(".") ? name.startsWith(c2) : name.equals(c2))) continue;
                return result;
            }
        }
        return false;
    }

    public boolean isSystemPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] system_classes = this._context.getSystemClasses();
        if (system_classes != null) {
            for (int i2 = 0; i2 < system_classes.length; ++i2) {
                boolean result = true;
                String c2 = system_classes[i2];
                if (c2.startsWith("-")) {
                    c2 = c2.substring(1);
                    result = false;
                }
                if (!(c2.endsWith(".") ? name.startsWith(c2) : name.equals(c2))) continue;
                return result;
            }
        }
        return false;
    }

    public void destroy() {
        this._parent = null;
        this._permissions = null;
        this._urlClassPath = null;
    }

    String[] getServerClasses() {
        return this._context.getServerClasses();
    }

    void setServerClasses(String[] serverClasses) {
        this._context.setServerClasses(serverClasses);
    }

    String[] getSystemClasses() {
        return this._context.getSystemClasses();
    }

    void setSystemClasses(String[] systemClasses) {
        this._context.setSystemClasses(systemClasses);
    }
}

