/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;

public class DumpHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(DumpHandler.class);

    public String realPath(String pathSpec, String path) {
        return "";
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (!this.isStarted()) {
            return;
        }
        if (!("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod()) || "POST".equals(request.getMethod()))) {
            return;
        }
        log.debug("Dump");
        response.setField("Content-Type", "text/html");
        OutputStream out = response.getOutputStream();
        ByteArrayOutputStream buf = new ByteArrayOutputStream(2048);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, StringUtil.__ISO_8859_1);
        writer.write("<HTML><H1>Dump HttpHandler</H1>");
        writer.write("<PRE>\npath=" + request.getPath() + "\ncontextPath=" + this.getHttpContext().getContextPath() + "\npathInContext=" + pathInContext + "\n</PRE>\n");
        writer.write("<H3>Header:</H3><PRE>");
        writer.write(request.toString());
        writer.write("</PRE>\n<H3>Parameters:</H3>\n<PRE>");
        Set names = request.getParameterNames();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = iter.next().toString();
            List values = request.getParameterValues(name);
            if (values == null || values.size() == 0) {
                writer.write(name);
                writer.write("=\n");
                continue;
            }
            if (values.size() == 1) {
                writer.write(name);
                writer.write("=");
                writer.write((String)values.get(0));
                writer.write("\n");
                continue;
            }
            for (int i2 = 0; i2 < values.size(); ++i2) {
                writer.write(name);
                writer.write("[" + i2 + "]=");
                writer.write((String)values.get(i2));
                writer.write("\n");
            }
        }
        String cookie_name = request.getParameter("CookieName");
        if (cookie_name != null && cookie_name.trim().length() > 0) {
            String cookie_action = request.getParameter("Button");
            try {
                Cookie cookie = new Cookie(cookie_name.trim(), request.getParameter("CookieVal"));
                if ("Clear Cookie".equals(cookie_action)) {
                    cookie.setMaxAge(0);
                }
                response.addSetCookie(cookie);
            }
            catch (IllegalArgumentException e2) {
                writer.write("</PRE>\n<H3>BAD Set-Cookie:</H3>\n<PRE>");
                writer.write(e2.toString());
                LogSupport.ignore(log, e2);
            }
        }
        writer.write("</PRE>\n<H3>Cookies:</H3>\n<PRE>");
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (int c2 = 0; c2 < cookies.length; ++c2) {
                Cookie cookie = cookies[c2];
                writer.write(cookie.getName());
                writer.write("=");
                writer.write(cookie.getValue());
                writer.write("\n");
            }
        }
        writer.write("</PRE>\n<H3>Attributes:</H3>\n<PRE>");
        Enumeration attributes = request.getAttributeNames();
        if (attributes != null && attributes.hasMoreElements()) {
            while (attributes.hasMoreElements()) {
                String attr = attributes.nextElement().toString();
                writer.write(attr);
                writer.write("=");
                writer.write(request.getAttribute(attr).toString());
                writer.write("\n");
            }
        }
        writer.write("</PRE>\n<H3>Content:</H3>\n<PRE>");
        byte[] content = new byte[4096];
        try {
            int len;
            InputStream in = request.getInputStream();
            while ((len = in.read(content)) >= 0) {
                writer.write(new String(content, 0, len));
            }
        }
        catch (IOException e3) {
            LogSupport.ignore(log, e3);
            writer.write(e3.toString());
        }
        request.getAcceptableTransferCodings();
        ((Writer)writer).flush();
        response.setIntField("Content-Length", buf.size() + 1000);
        buf.writeTo(out);
        out.flush();
        buf.reset();
        writer.write("</PRE>\n<H3>Response:</H3>\n<PRE>");
        writer.write(response.toString());
        writer.write("</PRE></HTML>");
        ((Writer)writer).flush();
        int pad = 998 - buf.size();
        while (pad-- > 0) {
            writer.write(" ");
        }
        writer.write("\r\n");
        ((Writer)writer).flush();
        buf.writeTo(out);
        request.setHandled(true);
    }
}

