/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;

class ServletWriter
extends PrintWriter {
    private static Log log = LogFactory.getLog(ServletWriter.class);
    String encoding = null;
    OutputStream os = null;
    boolean written = false;

    ServletWriter(OutputStream os) throws IOException {
        super(os instanceof HttpOutputStream ? ((HttpOutputStream)os).getWriter(null) : new OutputStreamWriter(os));
        this.os = os;
    }

    ServletWriter(OutputStream os, String encoding) throws IOException {
        super(os instanceof HttpOutputStream ? ((HttpOutputStream)os).getWriter(encoding) : new OutputStreamWriter(os, encoding));
        this.os = os;
        this.encoding = encoding;
    }

    public void disable() {
        this.out = IO.getNullWriter();
    }

    public void reset() {
        try {
            this.out = IO.getNullWriter();
            super.flush();
            this.out = new OutputStreamWriter(this.os, this.encoding);
            this.written = false;
        }
        catch (UnsupportedEncodingException e2) {
            log.fatal(e2);
            System.exit(1);
        }
    }

    public boolean isWritten() {
        return this.written;
    }

    public void print(boolean p2) {
        this.written = true;
        super.print(p2);
    }

    public void print(char p2) {
        this.written = true;
        super.print(p2);
    }

    public void print(char[] p2) {
        this.written = true;
        super.print(p2);
    }

    public void print(double p2) {
        this.written = true;
        super.print(p2);
    }

    public void print(float p2) {
        this.written = true;
        super.print(p2);
    }

    public void print(int p2) {
        this.written = true;
        super.print(p2);
    }

    public void print(long p2) {
        this.written = true;
        super.print(p2);
    }

    public void print(Object p2) {
        this.written = true;
        super.print(p2);
    }

    public void print(String p2) {
        this.written = true;
        super.print(p2);
    }

    public void println() {
        this.written = true;
        super.println();
    }

    public void println(boolean p2) {
        this.written = true;
        super.println(p2);
    }

    public void println(char p2) {
        this.written = true;
        super.println(p2);
    }

    public void println(char[] p2) {
        this.written = true;
        super.println(p2);
    }

    public void println(double p2) {
        this.written = true;
        super.println(p2);
    }

    public void println(float p2) {
        this.written = true;
        super.println(p2);
    }

    public void println(int p2) {
        this.written = true;
        super.println(p2);
    }

    public void println(long p2) {
        this.written = true;
        super.println(p2);
    }

    public void println(Object p2) {
        this.written = true;
        super.println(p2);
    }

    public void println(String p2) {
        this.written = true;
        super.println(p2);
    }

    public void write(int c2) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(c2);
        }
        catch (IOException e2) {
            LogSupport.ignore(log, e2);
            this.setError();
        }
    }

    public void write(char[] cbuf, int off, int len) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(cbuf, off, len);
        }
        catch (IOException e2) {
            LogSupport.ignore(log, e2);
            this.setError();
        }
    }

    public void write(char[] cbuf) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(cbuf, 0, cbuf.length);
        }
        catch (IOException e2) {
            LogSupport.ignore(log, e2);
            this.setError();
        }
    }

    public void write(String s2, int off, int len) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(s2, off, len);
        }
        catch (IOException e2) {
            LogSupport.ignore(log, e2);
            this.setError();
        }
    }

    public void write(String s2) {
        try {
            if (this.out == null) {
                throw new IOException("closed");
            }
            this.written = true;
            this.out.write(s2, 0, s2.length());
        }
        catch (IOException e2) {
            LogSupport.ignore(log, e2);
            this.setError();
        }
    }
}

