/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.mortbay.html.Block;
import org.mortbay.html.Break;
import org.mortbay.html.Font;
import org.mortbay.html.Page;
import org.mortbay.html.TableForm;
import org.mortbay.log.LogFactory;
import org.mortbay.log.LogImpl;
import org.mortbay.log.LogSink;
import org.mortbay.log.OutputStreamLogSink;

public class Debug
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Page page = new Page();
        page.title(this.getServletInfo());
        page.attribute("text", "#000000");
        page.attribute("bgcolor", "#FFFFFF");
        page.attribute("link", "#606CC0");
        page.attribute("vlink", "#606CC0");
        page.attribute("alink", "#606CC0");
        Log l2 = LogFactory.getLog(Debug.class);
        if (!(l2 instanceof LogImpl)) {
            return;
        }
        LogImpl log = (LogImpl)l2;
        TableForm tf = new TableForm(request.getRequestURI());
        page.add(tf);
        tf.table().newRow().addCell(new Block("b").add(new Font(3, true).add(this.getServletInfo()))).cell().attribute("COLSPAN", "2");
        tf.table().add(Break.rule);
        tf.addCheckbox("D", "Debug On", log.getDebug());
        tf.addTextField("V", "Verbosity Level", 6, "" + log.getVerbose());
        tf.addTextField("P", "Debug Patterns", 40, log.getDebugPatterns());
        tf.addCheckbox("W", "Suppress Warnings", log.getSuppressWarnings());
        LogSink[] sinks = log.getLogSinks();
        for (int s2 = 0; sinks != null && s2 < sinks.length; ++s2) {
            if (sinks[s2] == null) continue;
            tf.table().newRow().addCell(Break.rule).cell().attribute("COLSPAN", "2");
            tf.table().newRow().addCell("<B><font size=\"+1\">Log Sink " + s2 + ":</font></B").right();
            tf.table().addCell(sinks[s2].getClass().getName()).left();
            tf.addCheckbox("LSS" + s2, "Started", sinks[s2].isStarted());
            if (!(sinks[s2] instanceof OutputStreamLogSink)) continue;
            OutputStreamLogSink sink = (OutputStreamLogSink)sinks[s2];
            tf.addCheckbox("LT" + s2, "Tag", sink.isLogTags());
            tf.addCheckbox("LL" + s2, "Label", sink.isLogLabels());
            tf.addCheckbox("Ls" + s2, "Stack Size", sink.isLogStackSize());
            tf.addCheckbox("LS" + s2, "Stack Trace", sink.isLogStackTrace());
            tf.addCheckbox("SS" + s2, "Suppress Stacks", sink.isSuppressStack());
            tf.addCheckbox("SL" + s2, "Single Line", sink.isLogOneLine());
            tf.addTextField("LF" + s2, "Log File Name", 40, sink.getFilename());
        }
        tf.table().newRow().addCell(Break.rule).cell().attribute("COLSPAN", "2");
        tf.addTextField("LSC", "Add LogSink Class", 40, "org.mortbay.log.OutputStreamLogSink");
        tf.addButtonArea();
        tf.addButton("Action", "Set Options");
        tf.addButton("Action", "Add LogSink");
        tf.addButton("Action", "Delete Stopped Sinks");
        tf.table().newRow().addCell(Break.rule).cell().attribute("COLSPAN", "2");
        response.setContentType("text/html");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache,no-store");
        PrintWriter writer = response.getWriter();
        page.write(writer);
        ((Writer)writer).flush();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String target = null;
        Log l2 = LogFactory.getLog(Debug.class);
        if (!(l2 instanceof LogImpl)) {
            return;
        }
        LogImpl log = (LogImpl)l2;
        String action = request.getParameter("Action");
        if ("Set Options".equals(action)) {
            log.setDebug("on".equals(request.getParameter("D")));
            log.setSuppressWarnings("on".equals(request.getParameter("W")));
            String v2 = request.getParameter("V");
            if (v2 != null && v2.length() > 0) {
                log.setVerbose(Integer.parseInt(v2));
            } else {
                log.setVerbose(0);
            }
            log.setDebugPatterns(request.getParameter("P"));
            LogSink[] sinks = log.getLogSinks();
            for (int s2 = 0; sinks != null && s2 < sinks.length; ++s2) {
                String options;
                if (sinks[s2] == null) continue;
                if ("on".equals(request.getParameter("LSS" + s2))) {
                    if (!sinks[s2].isStarted()) {
                        try {
                            sinks[s2].start();
                        }
                        catch (Exception e2) {
                            log.warn(e2);
                        }
                    }
                } else if (sinks[s2].isStarted()) {
                    try {
                        sinks[s2].stop();
                    }
                    catch (InterruptedException e3) {
                        // empty catch block
                    }
                }
                if ((options = request.getParameter("LO" + s2)) == null) {
                    options = "";
                }
                if (!(sinks[s2] instanceof OutputStreamLogSink)) continue;
                OutputStreamLogSink sink = (OutputStreamLogSink)sinks[s2];
                sink.setLogTags("on".equals(request.getParameter("LT" + s2)));
                sink.setLogLabels("on".equals(request.getParameter("LL" + s2)));
                sink.setLogStackSize("on".equals(request.getParameter("Ls" + s2)));
                sink.setLogStackTrace("on".equals(request.getParameter("LS" + s2)));
                sink.setSuppressStack("on".equals(request.getParameter("SS" + s2)));
                sink.setLogOneLine("on".equals(request.getParameter("SL" + s2)));
                sink.setFilename(request.getParameter("LF" + s2));
            }
        } else if ("Add LogSink".equals(action)) {
            System.err.println("add log sink " + request.getParameter("LSC"));
            try {
                log.add(request.getParameter("LSC"));
            }
            catch (Exception e4) {
                log.warn(e4);
            }
        } else if ("Delete Stopped Sinks".equals(action)) {
            log.deleteStoppedLogSinks();
        }
        response.sendRedirect(request.getContextPath() + request.getServletPath() + "/" + Long.toString(System.currentTimeMillis(), 36) + (target != null ? "#" + target : ""));
    }

    public String getServletInfo() {
        return "Debug And  Log Options";
    }
}

